package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class Delivery {
  private String id;

  private String key;

  private OffsetDateTime createdAt;

  private List<DeliveryItem> items;

  private List<Parcel> parcels;

  private Address address;

  private CustomFieldsType custom;

  public Delivery() {
  }

  public Delivery(String id, String key, OffsetDateTime createdAt, List<DeliveryItem> items,
      List<Parcel> parcels, Address address, CustomFieldsType custom) {
    this.id = id;
    this.key = key;
    this.createdAt = createdAt;
    this.items = items;
    this.parcels = parcels;
    this.address = address;
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  public List<Parcel> getParcels() {
    return parcels;
  }

  public void setParcels(List<Parcel> parcels) {
    this.parcels = parcels;
  }

  public Address getAddress() {
    return address;
  }

  public void setAddress(Address address) {
    this.address = address;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "Delivery{id='" + id + "', key='" + key + "', createdAt='" + createdAt + "', items='" + items + "', parcels='" + parcels + "', address='" + address + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Delivery that = (Delivery) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(items, that.items) &&
        Objects.equals(parcels, that.parcels) &&
        Objects.equals(address, that.address) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, createdAt, items, parcels, address, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private OffsetDateTime createdAt;

    private List<DeliveryItem> items;

    private List<Parcel> parcels;

    private Address address;

    private CustomFieldsType custom;

    public Delivery build() {
      Delivery result = new Delivery();
      result.id = this.id;
      result.key = this.key;
      result.createdAt = this.createdAt;
      result.items = this.items;
      result.parcels = this.parcels;
      result.address = this.address;
      result.custom = this.custom;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }

    public Builder parcels(List<Parcel> parcels) {
      this.parcels = parcels;
      return this;
    }

    public Builder address(Address address) {
      this.address = address;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }
  }
}
