package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class DeliveryAddressSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String deliveryId;

  private Address address;

  private Address oldAddress;

  private String shippingKey;

  private String type;

  public DeliveryAddressSet() {
  }

  public DeliveryAddressSet(String deliveryId, Address address, Address oldAddress,
      String shippingKey, String type) {
    this.deliveryId = deliveryId;
    this.address = address;
    this.oldAddress = oldAddress;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public Address getAddress() {
    return address;
  }

  public void setAddress(Address address) {
    this.address = address;
  }

  public Address getOldAddress() {
    return oldAddress;
  }

  public void setOldAddress(Address oldAddress) {
    this.oldAddress = oldAddress;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "DeliveryAddressSet{deliveryId='" + deliveryId + "', address='" + address + "', oldAddress='" + oldAddress + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryAddressSet that = (DeliveryAddressSet) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(address, that.address) &&
        Objects.equals(oldAddress, that.oldAddress) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, address, oldAddress, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private Address address;

    private Address oldAddress;

    private String shippingKey;

    private String type;

    public DeliveryAddressSet build() {
      DeliveryAddressSet result = new DeliveryAddressSet();
      result.deliveryId = this.deliveryId;
      result.address = this.address;
      result.oldAddress = this.oldAddress;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder address(Address address) {
      this.address = address;
      return this;
    }

    public Builder oldAddress(Address oldAddress) {
      this.oldAddress = oldAddress;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
