package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class DeliveryDraft {
  private String key;

  private List<DeliveryItemDraftType> items;

  private List<ParcelDraft> parcels;

  private AddressInput address;

  private CustomFieldsDraft custom;

  public DeliveryDraft() {
  }

  public DeliveryDraft(String key, List<DeliveryItemDraftType> items, List<ParcelDraft> parcels,
      AddressInput address, CustomFieldsDraft custom) {
    this.key = key;
    this.items = items;
    this.parcels = parcels;
    this.address = address;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<DeliveryItemDraftType> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItemDraftType> items) {
    this.items = items;
  }

  public List<ParcelDraft> getParcels() {
    return parcels;
  }

  public void setParcels(List<ParcelDraft> parcels) {
    this.parcels = parcels;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "DeliveryDraft{key='" + key + "', items='" + items + "', parcels='" + parcels + "', address='" + address + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryDraft that = (DeliveryDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(items, that.items) &&
        Objects.equals(parcels, that.parcels) &&
        Objects.equals(address, that.address) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, items, parcels, address, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<DeliveryItemDraftType> items;

    private List<ParcelDraft> parcels;

    private AddressInput address;

    private CustomFieldsDraft custom;

    public DeliveryDraft build() {
      DeliveryDraft result = new DeliveryDraft();
      result.key = this.key;
      result.items = this.items;
      result.parcels = this.parcels;
      result.address = this.address;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder items(List<DeliveryItemDraftType> items) {
      this.items = items;
      return this;
    }

    public Builder parcels(List<ParcelDraft> parcels) {
      this.parcels = parcels;
      return this;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
