package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AzureServiceBusDestination.class, name = "AzureServiceBusDestination"),
    @JsonSubTypes.Type(value = ConfluentCloudDestination.class, name = "ConfluentCloudDestination"),
    @JsonSubTypes.Type(value = EventBridgeDestination.class, name = "EventBridgeDestination"),
    @JsonSubTypes.Type(value = EventGridDestination.class, name = "EventGridDestination"),
    @JsonSubTypes.Type(value = GoogleCloudPubSubDestination.class, name = "GoogleCloudPubSubDestination"),
    @JsonSubTypes.Type(value = SNSDestination.class, name = "SNSDestination"),
    @JsonSubTypes.Type(value = SQSDestination.class, name = "SQSDestination")
})
public interface Destination {
  String getType();

  void setType(String type);
}
