package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DestinationInput {
  private SQSDestinationInput SQS;

  private SNSDestinationInput SNS;

  private AzureServiceBusDestinationInput AzureServiceBus;

  private EventGridDestinationInput EventGrid;

  private GoogleCloudPubSubDestinationInput GoogleCloudPubSub;

  private EventBridgeDestinationInput EventBridge;

  private ConfluentCloudDestinationInput ConfluentCloud;

  public DestinationInput() {
  }

  public DestinationInput(SQSDestinationInput SQS, SNSDestinationInput SNS,
      AzureServiceBusDestinationInput AzureServiceBus, EventGridDestinationInput EventGrid,
      GoogleCloudPubSubDestinationInput GoogleCloudPubSub, EventBridgeDestinationInput EventBridge,
      ConfluentCloudDestinationInput ConfluentCloud) {
    this.SQS = SQS;
    this.SNS = SNS;
    this.AzureServiceBus = AzureServiceBus;
    this.EventGrid = EventGrid;
    this.GoogleCloudPubSub = GoogleCloudPubSub;
    this.EventBridge = EventBridge;
    this.ConfluentCloud = ConfluentCloud;
  }

  public SQSDestinationInput getSQS() {
    return SQS;
  }

  public void setSQS(SQSDestinationInput SQS) {
    this.SQS = SQS;
  }

  public SNSDestinationInput getSNS() {
    return SNS;
  }

  public void setSNS(SNSDestinationInput SNS) {
    this.SNS = SNS;
  }

  public AzureServiceBusDestinationInput getAzureServiceBus() {
    return AzureServiceBus;
  }

  public void setAzureServiceBus(AzureServiceBusDestinationInput AzureServiceBus) {
    this.AzureServiceBus = AzureServiceBus;
  }

  public EventGridDestinationInput getEventGrid() {
    return EventGrid;
  }

  public void setEventGrid(EventGridDestinationInput EventGrid) {
    this.EventGrid = EventGrid;
  }

  public GoogleCloudPubSubDestinationInput getGoogleCloudPubSub() {
    return GoogleCloudPubSub;
  }

  public void setGoogleCloudPubSub(GoogleCloudPubSubDestinationInput GoogleCloudPubSub) {
    this.GoogleCloudPubSub = GoogleCloudPubSub;
  }

  public EventBridgeDestinationInput getEventBridge() {
    return EventBridge;
  }

  public void setEventBridge(EventBridgeDestinationInput EventBridge) {
    this.EventBridge = EventBridge;
  }

  public ConfluentCloudDestinationInput getConfluentCloud() {
    return ConfluentCloud;
  }

  public void setConfluentCloud(ConfluentCloudDestinationInput ConfluentCloud) {
    this.ConfluentCloud = ConfluentCloud;
  }

  @Override
  public String toString() {
    return "DestinationInput{SQS='" + SQS + "', SNS='" + SNS + "', AzureServiceBus='" + AzureServiceBus + "', EventGrid='" + EventGrid + "', GoogleCloudPubSub='" + GoogleCloudPubSub + "', EventBridge='" + EventBridge + "', ConfluentCloud='" + ConfluentCloud + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DestinationInput that = (DestinationInput) o;
    return Objects.equals(SQS, that.SQS) &&
        Objects.equals(SNS, that.SNS) &&
        Objects.equals(AzureServiceBus, that.AzureServiceBus) &&
        Objects.equals(EventGrid, that.EventGrid) &&
        Objects.equals(GoogleCloudPubSub, that.GoogleCloudPubSub) &&
        Objects.equals(EventBridge, that.EventBridge) &&
        Objects.equals(ConfluentCloud, that.ConfluentCloud);
  }

  @Override
  public int hashCode() {
    return Objects.hash(SQS, SNS, AzureServiceBus, EventGrid, GoogleCloudPubSub, EventBridge, ConfluentCloud);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SQSDestinationInput SQS;

    private SNSDestinationInput SNS;

    private AzureServiceBusDestinationInput AzureServiceBus;

    private EventGridDestinationInput EventGrid;

    private GoogleCloudPubSubDestinationInput GoogleCloudPubSub;

    private EventBridgeDestinationInput EventBridge;

    private ConfluentCloudDestinationInput ConfluentCloud;

    public DestinationInput build() {
      DestinationInput result = new DestinationInput();
      result.SQS = this.SQS;
      result.SNS = this.SNS;
      result.AzureServiceBus = this.AzureServiceBus;
      result.EventGrid = this.EventGrid;
      result.GoogleCloudPubSub = this.GoogleCloudPubSub;
      result.EventBridge = this.EventBridge;
      result.ConfluentCloud = this.ConfluentCloud;
      return result;
    }

    public Builder SQS(SQSDestinationInput SQS) {
      this.SQS = SQS;
      return this;
    }

    public Builder SNS(SNSDestinationInput SNS) {
      this.SNS = SNS;
      return this;
    }

    public Builder AzureServiceBus(AzureServiceBusDestinationInput AzureServiceBus) {
      this.AzureServiceBus = AzureServiceBus;
      return this;
    }

    public Builder EventGrid(EventGridDestinationInput EventGrid) {
      this.EventGrid = EventGrid;
      return this;
    }

    public Builder GoogleCloudPubSub(GoogleCloudPubSubDestinationInput GoogleCloudPubSub) {
      this.GoogleCloudPubSub = GoogleCloudPubSub;
      return this;
    }

    public Builder EventBridge(EventBridgeDestinationInput EventBridge) {
      this.EventBridge = EventBridge;
      return this;
    }

    public Builder ConfluentCloud(ConfluentCloudDestinationInput ConfluentCloud) {
      this.ConfluentCloud = ConfluentCloud;
      return this;
    }
  }
}
