package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DirectDiscount {
  private String id;

  private CartDiscountValue value;

  private CartDiscountTarget target;

  public DirectDiscount() {
  }

  public DirectDiscount(String id, CartDiscountValue value, CartDiscountTarget target) {
    this.id = id;
    this.value = value;
    this.target = target;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CartDiscountValue getValue() {
    return value;
  }

  public void setValue(CartDiscountValue value) {
    this.value = value;
  }

  public CartDiscountTarget getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTarget target) {
    this.target = target;
  }

  @Override
  public String toString() {
    return "DirectDiscount{id='" + id + "', value='" + value + "', target='" + target + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DirectDiscount that = (DirectDiscount) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(value, that.value) &&
        Objects.equals(target, that.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, value, target);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private CartDiscountValue value;

    private CartDiscountTarget target;

    public DirectDiscount build() {
      DirectDiscount result = new DirectDiscount();
      result.id = this.id;
      result.value = this.value;
      result.target = this.target;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder value(CartDiscountValue value) {
      this.value = value;
      return this;
    }

    public Builder target(CartDiscountTarget target) {
      this.target = target;
      return this;
    }
  }
}
