package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class DiscountCodeCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private DiscountCode discountCode;

  private String type;

  public DiscountCodeCreated() {
  }

  public DiscountCodeCreated(DiscountCode discountCode, String type) {
    this.discountCode = discountCode;
    this.type = type;
  }

  public DiscountCode getDiscountCode() {
    return discountCode;
  }

  public void setDiscountCode(DiscountCode discountCode) {
    this.discountCode = discountCode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "DiscountCodeCreated{discountCode='" + discountCode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountCodeCreated that = (DiscountCodeCreated) o;
    return Objects.equals(discountCode, that.discountCode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountCode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DiscountCode discountCode;

    private String type;

    public DiscountCodeCreated build() {
      DiscountCodeCreated result = new DiscountCodeCreated();
      result.discountCode = this.discountCode;
      result.type = this.type;
      return result;
    }

    public Builder discountCode(DiscountCode discountCode) {
      this.discountCode = discountCode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
