package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DiscountCodeDraft {
  private String code;

  private List<LocalizedStringItemInputType> name;

  private String key;

  private List<LocalizedStringItemInputType> description;

  private List<ResourceIdentifierInput> cartDiscounts;

  private Boolean isActive = true;

  private Long maxApplications;

  private Long maxApplicationsPerCustomer;

  private String cartPredicate;

  private CustomFieldsDraft custom;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private List<String> groups = Collections.emptyList();

  public DiscountCodeDraft() {
  }

  public DiscountCodeDraft(String code, List<LocalizedStringItemInputType> name, String key,
      List<LocalizedStringItemInputType> description, List<ResourceIdentifierInput> cartDiscounts,
      Boolean isActive, Long maxApplications, Long maxApplicationsPerCustomer, String cartPredicate,
      CustomFieldsDraft custom, OffsetDateTime validFrom, OffsetDateTime validUntil,
      List<String> groups) {
    this.code = code;
    this.name = name;
    this.key = key;
    this.description = description;
    this.cartDiscounts = cartDiscounts;
    this.isActive = isActive;
    this.maxApplications = maxApplications;
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
    this.cartPredicate = cartPredicate;
    this.custom = custom;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.groups = groups;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<ResourceIdentifierInput> getCartDiscounts() {
    return cartDiscounts;
  }

  public void setCartDiscounts(List<ResourceIdentifierInput> cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public Long getMaxApplications() {
    return maxApplications;
  }

  public void setMaxApplications(Long maxApplications) {
    this.maxApplications = maxApplications;
  }

  public Long getMaxApplicationsPerCustomer() {
    return maxApplicationsPerCustomer;
  }

  public void setMaxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public List<String> getGroups() {
    return groups;
  }

  public void setGroups(List<String> groups) {
    this.groups = groups;
  }

  @Override
  public String toString() {
    return "DiscountCodeDraft{code='" + code + "', name='" + name + "', key='" + key + "', description='" + description + "', cartDiscounts='" + cartDiscounts + "', isActive='" + isActive + "', maxApplications='" + maxApplications + "', maxApplicationsPerCustomer='" + maxApplicationsPerCustomer + "', cartPredicate='" + cartPredicate + "', custom='" + custom + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', groups='" + groups + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountCodeDraft that = (DiscountCodeDraft) o;
    return Objects.equals(code, that.code) &&
        Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(description, that.description) &&
        Objects.equals(cartDiscounts, that.cartDiscounts) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(maxApplications, that.maxApplications) &&
        Objects.equals(maxApplicationsPerCustomer, that.maxApplicationsPerCustomer) &&
        Objects.equals(cartPredicate, that.cartPredicate) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(groups, that.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, name, key, description, cartDiscounts, isActive, maxApplications, maxApplicationsPerCustomer, cartPredicate, custom, validFrom, validUntil, groups);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String code;

    private List<LocalizedStringItemInputType> name;

    private String key;

    private List<LocalizedStringItemInputType> description;

    private List<ResourceIdentifierInput> cartDiscounts;

    private Boolean isActive = true;

    private Long maxApplications;

    private Long maxApplicationsPerCustomer;

    private String cartPredicate;

    private CustomFieldsDraft custom;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private List<String> groups = Collections.emptyList();

    public DiscountCodeDraft build() {
      DiscountCodeDraft result = new DiscountCodeDraft();
      result.code = this.code;
      result.name = this.name;
      result.key = this.key;
      result.description = this.description;
      result.cartDiscounts = this.cartDiscounts;
      result.isActive = this.isActive;
      result.maxApplications = this.maxApplications;
      result.maxApplicationsPerCustomer = this.maxApplicationsPerCustomer;
      result.cartPredicate = this.cartPredicate;
      result.custom = this.custom;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.groups = this.groups;
      return result;
    }

    public Builder code(String code) {
      this.code = code;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder cartDiscounts(List<ResourceIdentifierInput> cartDiscounts) {
      this.cartDiscounts = cartDiscounts;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder maxApplications(Long maxApplications) {
      this.maxApplications = maxApplications;
      return this;
    }

    public Builder maxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
      this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
      return this;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder groups(List<String> groups) {
      this.groups = groups;
      return this;
    }
  }
}
