package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = Stacking.class, name = "Stacking"),
    @JsonSubTypes.Type(value = BestDeal.class, name = "BestDeal")
})
public interface DiscountTypeCombination {
  String getType();

  void setType(String type);
}
