package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountedLineItemPortion {
  private CartDiscount discount;

  private Reference discountRef;

  private BaseMoney discountedAmount;

  public DiscountedLineItemPortion() {
  }

  public DiscountedLineItemPortion(CartDiscount discount, Reference discountRef,
      BaseMoney discountedAmount) {
    this.discount = discount;
    this.discountRef = discountRef;
    this.discountedAmount = discountedAmount;
  }

  public CartDiscount getDiscount() {
    return discount;
  }

  public void setDiscount(CartDiscount discount) {
    this.discount = discount;
  }

  public Reference getDiscountRef() {
    return discountRef;
  }

  public void setDiscountRef(Reference discountRef) {
    this.discountRef = discountRef;
  }

  public BaseMoney getDiscountedAmount() {
    return discountedAmount;
  }

  public void setDiscountedAmount(BaseMoney discountedAmount) {
    this.discountedAmount = discountedAmount;
  }

  @Override
  public String toString() {
    return "DiscountedLineItemPortion{discount='" + discount + "', discountRef='" + discountRef + "', discountedAmount='" + discountedAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedLineItemPortion that = (DiscountedLineItemPortion) o;
    return Objects.equals(discount, that.discount) &&
        Objects.equals(discountRef, that.discountRef) &&
        Objects.equals(discountedAmount, that.discountedAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discount, discountRef, discountedAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscount discount;

    private Reference discountRef;

    private BaseMoney discountedAmount;

    public DiscountedLineItemPortion build() {
      DiscountedLineItemPortion result = new DiscountedLineItemPortion();
      result.discount = this.discount;
      result.discountRef = this.discountRef;
      result.discountedAmount = this.discountedAmount;
      return result;
    }

    public Builder discount(CartDiscount discount) {
      this.discount = discount;
      return this;
    }

    public Builder discountRef(Reference discountRef) {
      this.discountRef = discountRef;
      return this;
    }

    public Builder discountedAmount(BaseMoney discountedAmount) {
      this.discountedAmount = discountedAmount;
      return this;
    }
  }
}
