package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class DiscountedLineItemPortionDraft {
  private ReferenceInput discount;

  private BaseMoneyInput discountedAmount;

  public DiscountedLineItemPortionDraft() {
  }

  public DiscountedLineItemPortionDraft(ReferenceInput discount, BaseMoneyInput discountedAmount) {
    this.discount = discount;
    this.discountedAmount = discountedAmount;
  }

  public ReferenceInput getDiscount() {
    return discount;
  }

  public void setDiscount(ReferenceInput discount) {
    this.discount = discount;
  }

  public BaseMoneyInput getDiscountedAmount() {
    return discountedAmount;
  }

  public void setDiscountedAmount(BaseMoneyInput discountedAmount) {
    this.discountedAmount = discountedAmount;
  }

  @Override
  public String toString() {
    return "DiscountedLineItemPortionDraft{discount='" + discount + "', discountedAmount='" + discountedAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedLineItemPortionDraft that = (DiscountedLineItemPortionDraft) o;
    return Objects.equals(discount, that.discount) &&
        Objects.equals(discountedAmount, that.discountedAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discount, discountedAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ReferenceInput discount;

    private BaseMoneyInput discountedAmount;

    public DiscountedLineItemPortionDraft build() {
      DiscountedLineItemPortionDraft result = new DiscountedLineItemPortionDraft();
      result.discount = this.discount;
      result.discountedAmount = this.discountedAmount;
      return result;
    }

    public Builder discount(ReferenceInput discount) {
      this.discount = discount;
      return this;
    }

    public Builder discountedAmount(BaseMoneyInput discountedAmount) {
      this.discountedAmount = discountedAmount;
      return this;
    }
  }
}
