package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class DiscountedLineItemPrice {
  private BaseMoney value;

  private List<DiscountedLineItemPortion> includedDiscounts;

  public DiscountedLineItemPrice() {
  }

  public DiscountedLineItemPrice(BaseMoney value,
      List<DiscountedLineItemPortion> includedDiscounts) {
    this.value = value;
    this.includedDiscounts = includedDiscounts;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public List<DiscountedLineItemPortion> getIncludedDiscounts() {
    return includedDiscounts;
  }

  public void setIncludedDiscounts(List<DiscountedLineItemPortion> includedDiscounts) {
    this.includedDiscounts = includedDiscounts;
  }

  @Override
  public String toString() {
    return "DiscountedLineItemPrice{value='" + value + "', includedDiscounts='" + includedDiscounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedLineItemPrice that = (DiscountedLineItemPrice) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(includedDiscounts, that.includedDiscounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, includedDiscounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney value;

    private List<DiscountedLineItemPortion> includedDiscounts;

    public DiscountedLineItemPrice build() {
      DiscountedLineItemPrice result = new DiscountedLineItemPrice();
      result.value = this.value;
      result.includedDiscounts = this.includedDiscounts;
      return result;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder includedDiscounts(List<DiscountedLineItemPortion> includedDiscounts) {
      this.includedDiscounts = includedDiscounts;
      return this;
    }
  }
}
