package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DiscountedLineItemPriceDraft {
  private BaseMoneyInput value;

  private List<DiscountedLineItemPortionDraft> includedDiscounts = Collections.emptyList();

  public DiscountedLineItemPriceDraft() {
  }

  public DiscountedLineItemPriceDraft(BaseMoneyInput value,
      List<DiscountedLineItemPortionDraft> includedDiscounts) {
    this.value = value;
    this.includedDiscounts = includedDiscounts;
  }

  public BaseMoneyInput getValue() {
    return value;
  }

  public void setValue(BaseMoneyInput value) {
    this.value = value;
  }

  public List<DiscountedLineItemPortionDraft> getIncludedDiscounts() {
    return includedDiscounts;
  }

  public void setIncludedDiscounts(List<DiscountedLineItemPortionDraft> includedDiscounts) {
    this.includedDiscounts = includedDiscounts;
  }

  @Override
  public String toString() {
    return "DiscountedLineItemPriceDraft{value='" + value + "', includedDiscounts='" + includedDiscounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DiscountedLineItemPriceDraft that = (DiscountedLineItemPriceDraft) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(includedDiscounts, that.includedDiscounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, includedDiscounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoneyInput value;

    private List<DiscountedLineItemPortionDraft> includedDiscounts = Collections.emptyList();

    public DiscountedLineItemPriceDraft build() {
      DiscountedLineItemPriceDraft result = new DiscountedLineItemPriceDraft();
      result.value = this.value;
      result.includedDiscounts = this.includedDiscounts;
      return result;
    }

    public Builder value(BaseMoneyInput value) {
      this.value = value;
      return this;
    }

    public Builder includedDiscounts(List<DiscountedLineItemPortionDraft> includedDiscounts) {
      this.includedDiscounts = includedDiscounts;
      return this;
    }
  }
}
