package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class EnumAttributeDefinitionType implements com.commercetools.graphql.api.types.AttributeDefinitionType {
  private PlainEnumValueResult values;

  private String name;

  public EnumAttributeDefinitionType() {
  }

  public EnumAttributeDefinitionType(PlainEnumValueResult values, String name) {
    this.values = values;
    this.name = name;
  }

  public PlainEnumValueResult getValues() {
    return values;
  }

  public void setValues(PlainEnumValueResult values) {
    this.values = values;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "EnumAttributeDefinitionType{values='" + values + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnumAttributeDefinitionType that = (EnumAttributeDefinitionType) o;
    return Objects.equals(values, that.values) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PlainEnumValueResult values;

    private String name;

    public EnumAttributeDefinitionType build() {
      EnumAttributeDefinitionType result = new EnumAttributeDefinitionType();
      result.values = this.values;
      result.name = this.name;
      return result;
    }

    public Builder values(PlainEnumValueResult values) {
      this.values = values;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
