package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class EventGridDestination implements com.commercetools.graphql.api.types.Destination {
  private String uri;

  private String accessKey;

  private String type;

  public EventGridDestination() {
  }

  public EventGridDestination(String uri, String accessKey, String type) {
    this.uri = uri;
    this.accessKey = accessKey;
    this.type = type;
  }

  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "EventGridDestination{uri='" + uri + "', accessKey='" + accessKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventGridDestination that = (EventGridDestination) o;
    return Objects.equals(uri, that.uri) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uri, accessKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String uri;

    private String accessKey;

    private String type;

    public EventGridDestination build() {
      EventGridDestination result = new EventGridDestination();
      result.uri = this.uri;
      result.accessKey = this.accessKey;
      result.type = this.type;
      return result;
    }

    public Builder uri(String uri) {
      this.uri = uri;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
