package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class EventGridDestinationInput {
  private String uri;

  private String accessKey;

  public EventGridDestinationInput() {
  }

  public EventGridDestinationInput(String uri, String accessKey) {
    this.uri = uri;
    this.accessKey = accessKey;
  }

  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  @Override
  public String toString() {
    return "EventGridDestinationInput{uri='" + uri + "', accessKey='" + accessKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventGridDestinationInput that = (EventGridDestinationInput) o;
    return Objects.equals(uri, that.uri) &&
        Objects.equals(accessKey, that.accessKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uri, accessKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String uri;

    private String accessKey;

    public EventGridDestinationInput build() {
      EventGridDestinationInput result = new EventGridDestinationInput();
      result.uri = this.uri;
      result.accessKey = this.accessKey;
      return result;
    }

    public Builder uri(String uri) {
      this.uri = uri;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }
  }
}
