package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExcludeProductSelectionProduct {
  private ResourceIdentifierInput product;

  private ProductVariantExclusionDraft variantExclusion;

  public ExcludeProductSelectionProduct() {
  }

  public ExcludeProductSelectionProduct(ResourceIdentifierInput product,
      ProductVariantExclusionDraft variantExclusion) {
    this.product = product;
    this.variantExclusion = variantExclusion;
  }

  public ResourceIdentifierInput getProduct() {
    return product;
  }

  public void setProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  public ProductVariantExclusionDraft getVariantExclusion() {
    return variantExclusion;
  }

  public void setVariantExclusion(ProductVariantExclusionDraft variantExclusion) {
    this.variantExclusion = variantExclusion;
  }

  @Override
  public String toString() {
    return "ExcludeProductSelectionProduct{product='" + product + "', variantExclusion='" + variantExclusion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExcludeProductSelectionProduct that = (ExcludeProductSelectionProduct) o;
    return Objects.equals(product, that.product) &&
        Objects.equals(variantExclusion, that.variantExclusion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, variantExclusion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput product;

    private ProductVariantExclusionDraft variantExclusion;

    public ExcludeProductSelectionProduct build() {
      ExcludeProductSelectionProduct result = new ExcludeProductSelectionProduct();
      result.product = this.product;
      result.variantExclusion = this.variantExclusion;
      return result;
    }

    public Builder product(ResourceIdentifierInput product) {
      this.product = product;
      return this;
    }

    public Builder variantExclusion(ProductVariantExclusionDraft variantExclusion) {
      this.variantExclusion = variantExclusion;
      return this;
    }
  }
}
