package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExistsFilterInput {
  private String path;

  public ExistsFilterInput() {
  }

  public ExistsFilterInput(String path) {
    this.path = path;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  @Override
  public String toString() {
    return "ExistsFilterInput{path='" + path + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExistsFilterInput that = (ExistsFilterInput) o;
    return Objects.equals(path, that.path);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String path;

    public ExistsFilterInput build() {
      ExistsFilterInput result = new ExistsFilterInput();
      result.path = this.path;
      return result;
    }

    public Builder path(String path) {
      this.path = path;
      return this;
    }
  }
}
