package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExtensionDestinationInput {
  private HttpDestinationInput HTTP;

  private AWSLambdaDestinationInput AWSLambda;

  private GoogleCloudFunctionDestinationInput GoogleCloudFunction;

  public ExtensionDestinationInput() {
  }

  public ExtensionDestinationInput(HttpDestinationInput HTTP, AWSLambdaDestinationInput AWSLambda,
      GoogleCloudFunctionDestinationInput GoogleCloudFunction) {
    this.HTTP = HTTP;
    this.AWSLambda = AWSLambda;
    this.GoogleCloudFunction = GoogleCloudFunction;
  }

  public HttpDestinationInput getHTTP() {
    return HTTP;
  }

  public void setHTTP(HttpDestinationInput HTTP) {
    this.HTTP = HTTP;
  }

  public AWSLambdaDestinationInput getAWSLambda() {
    return AWSLambda;
  }

  public void setAWSLambda(AWSLambdaDestinationInput AWSLambda) {
    this.AWSLambda = AWSLambda;
  }

  public GoogleCloudFunctionDestinationInput getGoogleCloudFunction() {
    return GoogleCloudFunction;
  }

  public void setGoogleCloudFunction(GoogleCloudFunctionDestinationInput GoogleCloudFunction) {
    this.GoogleCloudFunction = GoogleCloudFunction;
  }

  @Override
  public String toString() {
    return "ExtensionDestinationInput{HTTP='" + HTTP + "', AWSLambda='" + AWSLambda + "', GoogleCloudFunction='" + GoogleCloudFunction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExtensionDestinationInput that = (ExtensionDestinationInput) o;
    return Objects.equals(HTTP, that.HTTP) &&
        Objects.equals(AWSLambda, that.AWSLambda) &&
        Objects.equals(GoogleCloudFunction, that.GoogleCloudFunction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(HTTP, AWSLambda, GoogleCloudFunction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private HttpDestinationInput HTTP;

    private AWSLambdaDestinationInput AWSLambda;

    private GoogleCloudFunctionDestinationInput GoogleCloudFunction;

    public ExtensionDestinationInput build() {
      ExtensionDestinationInput result = new ExtensionDestinationInput();
      result.HTTP = this.HTTP;
      result.AWSLambda = this.AWSLambda;
      result.GoogleCloudFunction = this.GoogleCloudFunction;
      return result;
    }

    public Builder HTTP(HttpDestinationInput HTTP) {
      this.HTTP = HTTP;
      return this;
    }

    public Builder AWSLambda(AWSLambdaDestinationInput AWSLambda) {
      this.AWSLambda = AWSLambda;
      return this;
    }

    public Builder GoogleCloudFunction(GoogleCloudFunctionDestinationInput GoogleCloudFunction) {
      this.GoogleCloudFunction = GoogleCloudFunction;
      return this;
    }
  }
}
