package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExtensionLimitsProjection {
  private Limit timeoutInMs;

  public ExtensionLimitsProjection() {
  }

  public ExtensionLimitsProjection(Limit timeoutInMs) {
    this.timeoutInMs = timeoutInMs;
  }

  public Limit getTimeoutInMs() {
    return timeoutInMs;
  }

  public void setTimeoutInMs(Limit timeoutInMs) {
    this.timeoutInMs = timeoutInMs;
  }

  @Override
  public String toString() {
    return "ExtensionLimitsProjection{timeoutInMs='" + timeoutInMs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExtensionLimitsProjection that = (ExtensionLimitsProjection) o;
    return Objects.equals(timeoutInMs, that.timeoutInMs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timeoutInMs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit timeoutInMs;

    public ExtensionLimitsProjection build() {
      ExtensionLimitsProjection result = new ExtensionLimitsProjection();
      result.timeoutInMs = this.timeoutInMs;
      return result;
    }

    public Builder timeoutInMs(Limit timeoutInMs) {
      this.timeoutInMs = timeoutInMs;
      return this;
    }
  }
}
