package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExtensionUpdateAction {
  private ChangeExtensionDestination changeDestination;

  private ChangeExtensionTriggers changeTriggers;

  private SetExtensionKey setKey;

  private SetExtensionTimeoutInMs setTimeoutInMs;

  public ExtensionUpdateAction() {
  }

  public ExtensionUpdateAction(ChangeExtensionDestination changeDestination,
      ChangeExtensionTriggers changeTriggers, SetExtensionKey setKey,
      SetExtensionTimeoutInMs setTimeoutInMs) {
    this.changeDestination = changeDestination;
    this.changeTriggers = changeTriggers;
    this.setKey = setKey;
    this.setTimeoutInMs = setTimeoutInMs;
  }

  public ChangeExtensionDestination getChangeDestination() {
    return changeDestination;
  }

  public void setChangeDestination(ChangeExtensionDestination changeDestination) {
    this.changeDestination = changeDestination;
  }

  public ChangeExtensionTriggers getChangeTriggers() {
    return changeTriggers;
  }

  public void setChangeTriggers(ChangeExtensionTriggers changeTriggers) {
    this.changeTriggers = changeTriggers;
  }

  public SetExtensionKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetExtensionKey setKey) {
    this.setKey = setKey;
  }

  public SetExtensionTimeoutInMs getSetTimeoutInMs() {
    return setTimeoutInMs;
  }

  public void setSetTimeoutInMs(SetExtensionTimeoutInMs setTimeoutInMs) {
    this.setTimeoutInMs = setTimeoutInMs;
  }

  @Override
  public String toString() {
    return "ExtensionUpdateAction{changeDestination='" + changeDestination + "', changeTriggers='" + changeTriggers + "', setKey='" + setKey + "', setTimeoutInMs='" + setTimeoutInMs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExtensionUpdateAction that = (ExtensionUpdateAction) o;
    return Objects.equals(changeDestination, that.changeDestination) &&
        Objects.equals(changeTriggers, that.changeTriggers) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setTimeoutInMs, that.setTimeoutInMs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDestination, changeTriggers, setKey, setTimeoutInMs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeExtensionDestination changeDestination;

    private ChangeExtensionTriggers changeTriggers;

    private SetExtensionKey setKey;

    private SetExtensionTimeoutInMs setTimeoutInMs;

    public ExtensionUpdateAction build() {
      ExtensionUpdateAction result = new ExtensionUpdateAction();
      result.changeDestination = this.changeDestination;
      result.changeTriggers = this.changeTriggers;
      result.setKey = this.setKey;
      result.setTimeoutInMs = this.setTimeoutInMs;
      return result;
    }

    public Builder changeDestination(ChangeExtensionDestination changeDestination) {
      this.changeDestination = changeDestination;
      return this;
    }

    public Builder changeTriggers(ChangeExtensionTriggers changeTriggers) {
      this.changeTriggers = changeTriggers;
      return this;
    }

    public Builder setKey(SetExtensionKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setTimeoutInMs(SetExtensionTimeoutInMs setTimeoutInMs) {
      this.setTimeoutInMs = setTimeoutInMs;
      return this;
    }
  }
}
