package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExternalLineItemTotalPrice {
  private BaseMoney price;

  private Money totalPrice;

  public ExternalLineItemTotalPrice() {
  }

  public ExternalLineItemTotalPrice(BaseMoney price, Money totalPrice) {
    this.price = price;
    this.totalPrice = totalPrice;
  }

  public BaseMoney getPrice() {
    return price;
  }

  public void setPrice(BaseMoney price) {
    this.price = price;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  @Override
  public String toString() {
    return "ExternalLineItemTotalPrice{price='" + price + "', totalPrice='" + totalPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalLineItemTotalPrice that = (ExternalLineItemTotalPrice) o;
    return Objects.equals(price, that.price) &&
        Objects.equals(totalPrice, that.totalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, totalPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney price;

    private Money totalPrice;

    public ExternalLineItemTotalPrice build() {
      ExternalLineItemTotalPrice result = new ExternalLineItemTotalPrice();
      result.price = this.price;
      result.totalPrice = this.totalPrice;
      return result;
    }

    public Builder price(BaseMoney price) {
      this.price = price;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }
  }
}
