package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExternalLineItemTotalPriceDraft {
  private BaseMoneyInput price;

  private MoneyInput totalPrice;

  public ExternalLineItemTotalPriceDraft() {
  }

  public ExternalLineItemTotalPriceDraft(BaseMoneyInput price, MoneyInput totalPrice) {
    this.price = price;
    this.totalPrice = totalPrice;
  }

  public BaseMoneyInput getPrice() {
    return price;
  }

  public void setPrice(BaseMoneyInput price) {
    this.price = price;
  }

  public MoneyInput getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(MoneyInput totalPrice) {
    this.totalPrice = totalPrice;
  }

  @Override
  public String toString() {
    return "ExternalLineItemTotalPriceDraft{price='" + price + "', totalPrice='" + totalPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalLineItemTotalPriceDraft that = (ExternalLineItemTotalPriceDraft) o;
    return Objects.equals(price, that.price) &&
        Objects.equals(totalPrice, that.totalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, totalPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoneyInput price;

    private MoneyInput totalPrice;

    public ExternalLineItemTotalPriceDraft build() {
      ExternalLineItemTotalPriceDraft result = new ExternalLineItemTotalPriceDraft();
      result.price = this.price;
      result.totalPrice = this.totalPrice;
      return result;
    }

    public Builder price(BaseMoneyInput price) {
      this.price = price;
      return this;
    }

    public Builder totalPrice(MoneyInput totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }
  }
}
