package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExternalTaxAmountDraft {
  private MoneyInput totalGross;

  private ExternalTaxRateDraft taxRate;

  public ExternalTaxAmountDraft() {
  }

  public ExternalTaxAmountDraft(MoneyInput totalGross, ExternalTaxRateDraft taxRate) {
    this.totalGross = totalGross;
    this.taxRate = taxRate;
  }

  public MoneyInput getTotalGross() {
    return totalGross;
  }

  public void setTotalGross(MoneyInput totalGross) {
    this.totalGross = totalGross;
  }

  public ExternalTaxRateDraft getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(ExternalTaxRateDraft taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "ExternalTaxAmountDraft{totalGross='" + totalGross + "', taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalTaxAmountDraft that = (ExternalTaxAmountDraft) o;
    return Objects.equals(totalGross, that.totalGross) &&
        Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalGross, taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput totalGross;

    private ExternalTaxRateDraft taxRate;

    public ExternalTaxAmountDraft build() {
      ExternalTaxAmountDraft result = new ExternalTaxAmountDraft();
      result.totalGross = this.totalGross;
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder totalGross(MoneyInput totalGross) {
      this.totalGross = totalGross;
      return this;
    }

    public Builder taxRate(ExternalTaxRateDraft taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
