package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ExternalTaxAmountDraftOutput {
  private Money totalGross;

  private ExternalTaxRateDraftOutput taxRate;

  public ExternalTaxAmountDraftOutput() {
  }

  public ExternalTaxAmountDraftOutput(Money totalGross, ExternalTaxRateDraftOutput taxRate) {
    this.totalGross = totalGross;
    this.taxRate = taxRate;
  }

  public Money getTotalGross() {
    return totalGross;
  }

  public void setTotalGross(Money totalGross) {
    this.totalGross = totalGross;
  }

  public ExternalTaxRateDraftOutput getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(ExternalTaxRateDraftOutput taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "ExternalTaxAmountDraftOutput{totalGross='" + totalGross + "', taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalTaxAmountDraftOutput that = (ExternalTaxAmountDraftOutput) o;
    return Objects.equals(totalGross, that.totalGross) &&
        Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalGross, taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Money totalGross;

    private ExternalTaxRateDraftOutput taxRate;

    public ExternalTaxAmountDraftOutput build() {
      ExternalTaxAmountDraftOutput result = new ExternalTaxAmountDraftOutput();
      result.totalGross = this.totalGross;
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder totalGross(Money totalGross) {
      this.totalGross = totalGross;
      return this;
    }

    public Builder taxRate(ExternalTaxRateDraftOutput taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
