package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ExternalTaxRateDraftOutput {
  private String name;

  private Double amount;

  private String country;

  private String state;

  private List<SubRate> subRates;

  private Boolean includedInPrice;

  public ExternalTaxRateDraftOutput() {
  }

  public ExternalTaxRateDraftOutput(String name, Double amount, String country, String state,
      List<SubRate> subRates, Boolean includedInPrice) {
    this.name = name;
    this.amount = amount;
    this.country = country;
    this.state = state;
    this.subRates = subRates;
    this.includedInPrice = includedInPrice;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public List<SubRate> getSubRates() {
    return subRates;
  }

  public void setSubRates(List<SubRate> subRates) {
    this.subRates = subRates;
  }

  public Boolean getIncludedInPrice() {
    return includedInPrice;
  }

  public void setIncludedInPrice(Boolean includedInPrice) {
    this.includedInPrice = includedInPrice;
  }

  @Override
  public String toString() {
    return "ExternalTaxRateDraftOutput{name='" + name + "', amount='" + amount + "', country='" + country + "', state='" + state + "', subRates='" + subRates + "', includedInPrice='" + includedInPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalTaxRateDraftOutput that = (ExternalTaxRateDraftOutput) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(country, that.country) &&
        Objects.equals(state, that.state) &&
        Objects.equals(subRates, that.subRates) &&
        Objects.equals(includedInPrice, that.includedInPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, amount, country, state, subRates, includedInPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Double amount;

    private String country;

    private String state;

    private List<SubRate> subRates;

    private Boolean includedInPrice;

    public ExternalTaxRateDraftOutput build() {
      ExternalTaxRateDraftOutput result = new ExternalTaxRateDraftOutput();
      result.name = this.name;
      result.amount = this.amount;
      result.country = this.country;
      result.state = this.state;
      result.subRates = this.subRates;
      result.includedInPrice = this.includedInPrice;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder amount(Double amount) {
      this.amount = amount;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder state(String state) {
      this.state = state;
      return this;
    }

    public Builder subRates(List<SubRate> subRates) {
      this.subRates = subRates;
      return this;
    }

    public Builder includedInPrice(Boolean includedInPrice) {
      this.includedInPrice = includedInPrice;
      return this;
    }
  }
}
