package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class FacetResultValue {
  private String facet;

  private FacetResult value;

  public FacetResultValue() {
  }

  public FacetResultValue(String facet, FacetResult value) {
    this.facet = facet;
    this.value = value;
  }

  public String getFacet() {
    return facet;
  }

  public void setFacet(String facet) {
    this.facet = facet;
  }

  public FacetResult getValue() {
    return value;
  }

  public void setValue(FacetResult value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "FacetResultValue{facet='" + facet + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FacetResultValue that = (FacetResultValue) o;
    return Objects.equals(facet, that.facet) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(facet, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String facet;

    private FacetResult value;

    public FacetResultValue build() {
      FacetResultValue result = new FacetResultValue();
      result.facet = this.facet;
      result.value = this.value;
      return result;
    }

    public Builder facet(String facet) {
      this.facet = facet;
      return this;
    }

    public Builder value(FacetResult value) {
      this.value = value;
      return this;
    }
  }
}
