package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * Field definitions describe custom fields and allow you to define some meta-information associated with the field.
 */
public class FieldDefinition {
  private String name;

  private Boolean required;

  private TextInputHint inputHint;

  private String label;

  private List<LocalizedString> labelAllLocales;

  private FieldType type;

  public FieldDefinition() {
  }

  public FieldDefinition(String name, Boolean required, TextInputHint inputHint, String label,
      List<LocalizedString> labelAllLocales, FieldType type) {
    this.name = name;
    this.required = required;
    this.inputHint = inputHint;
    this.label = label;
    this.labelAllLocales = labelAllLocales;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Boolean getRequired() {
    return required;
  }

  public void setRequired(Boolean required) {
    this.required = required;
  }

  public TextInputHint getInputHint() {
    return inputHint;
  }

  public void setInputHint(TextInputHint inputHint) {
    this.inputHint = inputHint;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public List<LocalizedString> getLabelAllLocales() {
    return labelAllLocales;
  }

  public void setLabelAllLocales(List<LocalizedString> labelAllLocales) {
    this.labelAllLocales = labelAllLocales;
  }

  public FieldType getType() {
    return type;
  }

  public void setType(FieldType type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "FieldDefinition{name='" + name + "', required='" + required + "', inputHint='" + inputHint + "', label='" + label + "', labelAllLocales='" + labelAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldDefinition that = (FieldDefinition) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(required, that.required) &&
        Objects.equals(inputHint, that.inputHint) &&
        Objects.equals(label, that.label) &&
        Objects.equals(labelAllLocales, that.labelAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, required, inputHint, label, labelAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Boolean required;

    private TextInputHint inputHint;

    private String label;

    private List<LocalizedString> labelAllLocales;

    private FieldType type;

    public FieldDefinition build() {
      FieldDefinition result = new FieldDefinition();
      result.name = this.name;
      result.required = this.required;
      result.inputHint = this.inputHint;
      result.label = this.label;
      result.labelAllLocales = this.labelAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder required(Boolean required) {
      this.required = required;
      return this;
    }

    public Builder inputHint(TextInputHint inputHint) {
      this.inputHint = inputHint;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }

    public Builder labelAllLocales(List<LocalizedString> labelAllLocales) {
      this.labelAllLocales = labelAllLocales;
      return this;
    }

    public Builder type(FieldType type) {
      this.type = type;
      return this;
    }
  }
}
