package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class FieldDefinitionInput {
  private FieldTypeInput type;

  private String name;

  private List<LocalizedStringItemInputType> label;

  private Boolean required;

  private TextInputHint inputHint;

  public FieldDefinitionInput() {
  }

  public FieldDefinitionInput(FieldTypeInput type, String name,
      List<LocalizedStringItemInputType> label, Boolean required, TextInputHint inputHint) {
    this.type = type;
    this.name = name;
    this.label = label;
    this.required = required;
    this.inputHint = inputHint;
  }

  public FieldTypeInput getType() {
    return type;
  }

  public void setType(FieldTypeInput type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  public Boolean getRequired() {
    return required;
  }

  public void setRequired(Boolean required) {
    this.required = required;
  }

  public TextInputHint getInputHint() {
    return inputHint;
  }

  public void setInputHint(TextInputHint inputHint) {
    this.inputHint = inputHint;
  }

  @Override
  public String toString() {
    return "FieldDefinitionInput{type='" + type + "', name='" + name + "', label='" + label + "', required='" + required + "', inputHint='" + inputHint + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldDefinitionInput that = (FieldDefinitionInput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(label, that.label) &&
        Objects.equals(required, that.required) &&
        Objects.equals(inputHint, that.inputHint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, label, required, inputHint);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private FieldTypeInput type;

    private String name;

    private List<LocalizedStringItemInputType> label;

    private Boolean required;

    private TextInputHint inputHint;

    public FieldDefinitionInput build() {
      FieldDefinitionInput result = new FieldDefinitionInput();
      result.type = this.type;
      result.name = this.name;
      result.label = this.label;
      result.required = this.required;
      result.inputHint = this.inputHint;
      return result;
    }

    public Builder type(FieldTypeInput type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }

    public Builder required(Boolean required) {
      this.required = required;
      return this;
    }

    public Builder inputHint(TextInputHint inputHint) {
      this.inputHint = inputHint;
      return this;
    }
  }
}
