package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = BooleanType.class, name = "BooleanType"),
    @JsonSubTypes.Type(value = DateTimeType.class, name = "DateTimeType"),
    @JsonSubTypes.Type(value = DateType.class, name = "DateType"),
    @JsonSubTypes.Type(value = EnumType.class, name = "EnumType"),
    @JsonSubTypes.Type(value = LocalizedEnumType.class, name = "LocalizedEnumType"),
    @JsonSubTypes.Type(value = LocalizedStringType.class, name = "LocalizedStringType"),
    @JsonSubTypes.Type(value = MoneyType.class, name = "MoneyType"),
    @JsonSubTypes.Type(value = NumberType.class, name = "NumberType"),
    @JsonSubTypes.Type(value = ReferenceType.class, name = "ReferenceType"),
    @JsonSubTypes.Type(value = SetType.class, name = "SetType"),
    @JsonSubTypes.Type(value = StringType.class, name = "StringType"),
    @JsonSubTypes.Type(value = TimeType.class, name = "TimeType")
})
public interface FieldType {
  String getName();

  void setName(String name);
}
