package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class FieldTypeSetTypeDraft {
  private FieldTypeSetElementTypeDraft elementType;

  public FieldTypeSetTypeDraft() {
  }

  public FieldTypeSetTypeDraft(FieldTypeSetElementTypeDraft elementType) {
    this.elementType = elementType;
  }

  public FieldTypeSetElementTypeDraft getElementType() {
    return elementType;
  }

  public void setElementType(FieldTypeSetElementTypeDraft elementType) {
    this.elementType = elementType;
  }

  @Override
  public String toString() {
    return "FieldTypeSetTypeDraft{elementType='" + elementType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FieldTypeSetTypeDraft that = (FieldTypeSetTypeDraft) o;
    return Objects.equals(elementType, that.elementType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private FieldTypeSetElementTypeDraft elementType;

    public FieldTypeSetTypeDraft build() {
      FieldTypeSetTypeDraft result = new FieldTypeSetTypeDraft();
      result.elementType = this.elementType;
      return result;
    }

    public Builder elementType(FieldTypeSetElementTypeDraft elementType) {
      this.elementType = elementType;
      return this;
    }
  }
}
