package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class FixedPriceDiscountValue implements com.commercetools.graphql.api.types.CartDiscountValue {
  private String type;

  private List<BaseMoney> money;

  public FixedPriceDiscountValue() {
  }

  public FixedPriceDiscountValue(String type, List<BaseMoney> money) {
    this.type = type;
    this.money = money;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<BaseMoney> getMoney() {
    return money;
  }

  public void setMoney(List<BaseMoney> money) {
    this.money = money;
  }

  @Override
  public String toString() {
    return "FixedPriceDiscountValue{type='" + type + "', money='" + money + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FixedPriceDiscountValue that = (FixedPriceDiscountValue) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(money, that.money);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, money);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<BaseMoney> money;

    public FixedPriceDiscountValue build() {
      FixedPriceDiscountValue result = new FixedPriceDiscountValue();
      result.type = this.type;
      result.money = this.money;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder money(List<BaseMoney> money) {
      this.money = money;
      return this;
    }
  }
}
