package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class FixedPriceDiscountValueInput {
  private List<CartDiscountValueBaseMoneyInput> money;

  public FixedPriceDiscountValueInput() {
  }

  public FixedPriceDiscountValueInput(List<CartDiscountValueBaseMoneyInput> money) {
    this.money = money;
  }

  public List<CartDiscountValueBaseMoneyInput> getMoney() {
    return money;
  }

  public void setMoney(List<CartDiscountValueBaseMoneyInput> money) {
    this.money = money;
  }

  @Override
  public String toString() {
    return "FixedPriceDiscountValueInput{money='" + money + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FixedPriceDiscountValueInput that = (FixedPriceDiscountValueInput) o;
    return Objects.equals(money, that.money);
  }

  @Override
  public int hashCode() {
    return Objects.hash(money);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CartDiscountValueBaseMoneyInput> money;

    public FixedPriceDiscountValueInput build() {
      FixedPriceDiscountValueInput result = new FixedPriceDiscountValueInput();
      result.money = this.money;
      return result;
    }

    public Builder money(List<CartDiscountValueBaseMoneyInput> money) {
      this.money = money;
      return this;
    }
  }
}
