package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class GiftLineItemValue implements com.commercetools.graphql.api.types.CartDiscountValue {
  private String type;

  private Integer variantId;

  private ProductReferenceIdentifier productRef;

  private ChannelReferenceIdentifier distributionChannelRef;

  private ChannelReferenceIdentifier supplyChannelRef;

  public GiftLineItemValue() {
  }

  public GiftLineItemValue(String type, Integer variantId, ProductReferenceIdentifier productRef,
      ChannelReferenceIdentifier distributionChannelRef,
      ChannelReferenceIdentifier supplyChannelRef) {
    this.type = type;
    this.variantId = variantId;
    this.productRef = productRef;
    this.distributionChannelRef = distributionChannelRef;
    this.supplyChannelRef = supplyChannelRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public ProductReferenceIdentifier getProductRef() {
    return productRef;
  }

  public void setProductRef(ProductReferenceIdentifier productRef) {
    this.productRef = productRef;
  }

  public ChannelReferenceIdentifier getDistributionChannelRef() {
    return distributionChannelRef;
  }

  public void setDistributionChannelRef(ChannelReferenceIdentifier distributionChannelRef) {
    this.distributionChannelRef = distributionChannelRef;
  }

  public ChannelReferenceIdentifier getSupplyChannelRef() {
    return supplyChannelRef;
  }

  public void setSupplyChannelRef(ChannelReferenceIdentifier supplyChannelRef) {
    this.supplyChannelRef = supplyChannelRef;
  }

  @Override
  public String toString() {
    return "GiftLineItemValue{type='" + type + "', variantId='" + variantId + "', productRef='" + productRef + "', distributionChannelRef='" + distributionChannelRef + "', supplyChannelRef='" + supplyChannelRef + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GiftLineItemValue that = (GiftLineItemValue) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(distributionChannelRef, that.distributionChannelRef) &&
        Objects.equals(supplyChannelRef, that.supplyChannelRef);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, variantId, productRef, distributionChannelRef, supplyChannelRef);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private Integer variantId;

    private ProductReferenceIdentifier productRef;

    private ChannelReferenceIdentifier distributionChannelRef;

    private ChannelReferenceIdentifier supplyChannelRef;

    public GiftLineItemValue build() {
      GiftLineItemValue result = new GiftLineItemValue();
      result.type = this.type;
      result.variantId = this.variantId;
      result.productRef = this.productRef;
      result.distributionChannelRef = this.distributionChannelRef;
      result.supplyChannelRef = this.supplyChannelRef;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder productRef(ProductReferenceIdentifier productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder distributionChannelRef(ChannelReferenceIdentifier distributionChannelRef) {
      this.distributionChannelRef = distributionChannelRef;
      return this;
    }

    public Builder supplyChannelRef(ChannelReferenceIdentifier supplyChannelRef) {
      this.supplyChannelRef = supplyChannelRef;
      return this;
    }
  }
}
