package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class GoogleCloudPubSubDestination implements com.commercetools.graphql.api.types.Destination {
  private String projectId;

  private String topic;

  private String type;

  public GoogleCloudPubSubDestination() {
  }

  public GoogleCloudPubSubDestination(String projectId, String topic, String type) {
    this.projectId = projectId;
    this.topic = topic;
    this.type = type;
  }

  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {
    this.topic = topic;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "GoogleCloudPubSubDestination{projectId='" + projectId + "', topic='" + topic + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleCloudPubSubDestination that = (GoogleCloudPubSubDestination) o;
    return Objects.equals(projectId, that.projectId) &&
        Objects.equals(topic, that.topic) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, topic, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String projectId;

    private String topic;

    private String type;

    public GoogleCloudPubSubDestination build() {
      GoogleCloudPubSubDestination result = new GoogleCloudPubSubDestination();
      result.projectId = this.projectId;
      result.topic = this.topic;
      result.type = this.type;
      return result;
    }

    public Builder projectId(String projectId) {
      this.projectId = projectId;
      return this;
    }

    public Builder topic(String topic) {
      this.topic = topic;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
