package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class GoogleCloudPubSubDestinationInput {
  private String projectId;

  private String topic;

  public GoogleCloudPubSubDestinationInput() {
  }

  public GoogleCloudPubSubDestinationInput(String projectId, String topic) {
    this.projectId = projectId;
    this.topic = topic;
  }

  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public String getTopic() {
    return topic;
  }

  public void setTopic(String topic) {
    this.topic = topic;
  }

  @Override
  public String toString() {
    return "GoogleCloudPubSubDestinationInput{projectId='" + projectId + "', topic='" + topic + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleCloudPubSubDestinationInput that = (GoogleCloudPubSubDestinationInput) o;
    return Objects.equals(projectId, that.projectId) &&
        Objects.equals(topic, that.topic);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, topic);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String projectId;

    private String topic;

    public GoogleCloudPubSubDestinationInput build() {
      GoogleCloudPubSubDestinationInput result = new GoogleCloudPubSubDestinationInput();
      result.projectId = this.projectId;
      result.topic = this.topic;
      return result;
    }

    public Builder projectId(String projectId) {
      this.projectId = projectId;
      return this;
    }

    public Builder topic(String topic) {
      this.topic = topic;
      return this;
    }
  }
}
