package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

public class HighPrecisionMoneyInput {
  private Currency currencyCode;

  private Long preciseAmount;

  private Integer fractionDigits;

  private Long centAmount;

  public HighPrecisionMoneyInput() {
  }

  public HighPrecisionMoneyInput(Currency currencyCode, Long preciseAmount, Integer fractionDigits,
      Long centAmount) {
    this.currencyCode = currencyCode;
    this.preciseAmount = preciseAmount;
    this.fractionDigits = fractionDigits;
    this.centAmount = centAmount;
  }

  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Long getPreciseAmount() {
    return preciseAmount;
  }

  public void setPreciseAmount(Long preciseAmount) {
    this.preciseAmount = preciseAmount;
  }

  public Integer getFractionDigits() {
    return fractionDigits;
  }

  public void setFractionDigits(Integer fractionDigits) {
    this.fractionDigits = fractionDigits;
  }

  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  @Override
  public String toString() {
    return "HighPrecisionMoneyInput{currencyCode='" + currencyCode + "', preciseAmount='" + preciseAmount + "', fractionDigits='" + fractionDigits + "', centAmount='" + centAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HighPrecisionMoneyInput that = (HighPrecisionMoneyInput) o;
    return Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(preciseAmount, that.preciseAmount) &&
        Objects.equals(fractionDigits, that.fractionDigits) &&
        Objects.equals(centAmount, that.centAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currencyCode, preciseAmount, fractionDigits, centAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Currency currencyCode;

    private Long preciseAmount;

    private Integer fractionDigits;

    private Long centAmount;

    public HighPrecisionMoneyInput build() {
      HighPrecisionMoneyInput result = new HighPrecisionMoneyInput();
      result.currencyCode = this.currencyCode;
      result.preciseAmount = this.preciseAmount;
      result.fractionDigits = this.fractionDigits;
      result.centAmount = this.centAmount;
      return result;
    }

    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    public Builder preciseAmount(Long preciseAmount) {
      this.preciseAmount = preciseAmount;
      return this;
    }

    public Builder fractionDigits(Integer fractionDigits) {
      this.fractionDigits = fractionDigits;
      return this;
    }

    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }
  }
}
