package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class HttpDestination implements com.commercetools.graphql.api.types.ExtensionDestination {
  private String type;

  private String url;

  private HttpDestinationAuthentication authentication;

  public HttpDestination() {
  }

  public HttpDestination(String type, String url, HttpDestinationAuthentication authentication) {
    this.type = type;
    this.url = url;
    this.authentication = authentication;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public HttpDestinationAuthentication getAuthentication() {
    return authentication;
  }

  public void setAuthentication(HttpDestinationAuthentication authentication) {
    this.authentication = authentication;
  }

  @Override
  public String toString() {
    return "HttpDestination{type='" + type + "', url='" + url + "', authentication='" + authentication + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpDestination that = (HttpDestination) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(url, that.url) &&
        Objects.equals(authentication, that.authentication);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, url, authentication);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String url;

    private HttpDestinationAuthentication authentication;

    public HttpDestination build() {
      HttpDestination result = new HttpDestination();
      result.type = this.type;
      result.url = this.url;
      result.authentication = this.authentication;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder authentication(HttpDestinationAuthentication authentication) {
      this.authentication = authentication;
      return this;
    }
  }
}
