package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Image {
  private String url;

  private Dimensions dimensions;

  private String label;

  public Image() {
  }

  public Image(String url, Dimensions dimensions, String label) {
    this.url = url;
    this.dimensions = dimensions;
    this.label = label;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public Dimensions getDimensions() {
    return dimensions;
  }

  public void setDimensions(Dimensions dimensions) {
    this.dimensions = dimensions;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "Image{url='" + url + "', dimensions='" + dimensions + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Image that = (Image) o;
    return Objects.equals(url, that.url) &&
        Objects.equals(dimensions, that.dimensions) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, dimensions, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String url;

    private Dimensions dimensions;

    private String label;

    public Image build() {
      Image result = new Image();
      result.url = this.url;
      result.dimensions = this.dimensions;
      result.label = this.label;
      return result;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder dimensions(Dimensions dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }
  }
}
