package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ImportOrderCustomLineItemState {
  private String customLineItemId;

  private String customLineItemKey;

  private List<ItemStateDraftType> state;

  public ImportOrderCustomLineItemState() {
  }

  public ImportOrderCustomLineItemState(String customLineItemId, String customLineItemKey,
      List<ItemStateDraftType> state) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.state = state;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public List<ItemStateDraftType> getState() {
    return state;
  }

  public void setState(List<ItemStateDraftType> state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ImportOrderCustomLineItemState{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImportOrderCustomLineItemState that = (ImportOrderCustomLineItemState) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private List<ItemStateDraftType> state;

    public ImportOrderCustomLineItemState build() {
      ImportOrderCustomLineItemState result = new ImportOrderCustomLineItemState();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.state = this.state;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder state(List<ItemStateDraftType> state) {
      this.state = state;
      return this;
    }
  }
}
