package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ImportOrderDraft {
  private String orderNumber;

  private String customerId;

  private String customerEmail;

  private ReferenceInput store;

  private List<LineItemImportDraft> lineItems = Collections.emptyList();

  private List<CustomLineItemImportDraft> customLineItems = Collections.emptyList();

  private MoneyInput totalPrice;

  private TaxedPriceDraft taxedPrice;

  private AddressInput shippingAddress;

  private AddressInput billingAddress;

  private ReferenceInput customerGroup;

  private String country;

  private OrderState orderState;

  private ShipmentState shipmentState;

  private PaymentState paymentState;

  private ShippingInfoImportDraft shippingInfo;

  private OffsetDateTime completedAt;

  private CustomFieldsDraft custom;

  private InventoryMode inventoryMode = InventoryMode.None;

  private ItemShippingDetailsDraft shippingDetails;

  private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;

  private CartOrigin origin = CartOrigin.Customer;

  private List<AddressInput> itemShippingAddresses = Collections.emptyList();

  private ReferenceInput state;

  private ReferenceInput paymentInfo;

  private String purchaseOrderNumber;

  public ImportOrderDraft() {
  }

  public ImportOrderDraft(String orderNumber, String customerId, String customerEmail,
      ReferenceInput store, List<LineItemImportDraft> lineItems,
      List<CustomLineItemImportDraft> customLineItems, MoneyInput totalPrice,
      TaxedPriceDraft taxedPrice, AddressInput shippingAddress, AddressInput billingAddress,
      ReferenceInput customerGroup, String country, OrderState orderState,
      ShipmentState shipmentState, PaymentState paymentState, ShippingInfoImportDraft shippingInfo,
      OffsetDateTime completedAt, CustomFieldsDraft custom, InventoryMode inventoryMode,
      ItemShippingDetailsDraft shippingDetails, TaxCalculationMode taxCalculationMode,
      CartOrigin origin, List<AddressInput> itemShippingAddresses, ReferenceInput state,
      ReferenceInput paymentInfo, String purchaseOrderNumber) {
    this.orderNumber = orderNumber;
    this.customerId = customerId;
    this.customerEmail = customerEmail;
    this.store = store;
    this.lineItems = lineItems;
    this.customLineItems = customLineItems;
    this.totalPrice = totalPrice;
    this.taxedPrice = taxedPrice;
    this.shippingAddress = shippingAddress;
    this.billingAddress = billingAddress;
    this.customerGroup = customerGroup;
    this.country = country;
    this.orderState = orderState;
    this.shipmentState = shipmentState;
    this.paymentState = paymentState;
    this.shippingInfo = shippingInfo;
    this.completedAt = completedAt;
    this.custom = custom;
    this.inventoryMode = inventoryMode;
    this.shippingDetails = shippingDetails;
    this.taxCalculationMode = taxCalculationMode;
    this.origin = origin;
    this.itemShippingAddresses = itemShippingAddresses;
    this.state = state;
    this.paymentInfo = paymentInfo;
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public String getCustomerEmail() {
    return customerEmail;
  }

  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }

  public ReferenceInput getStore() {
    return store;
  }

  public void setStore(ReferenceInput store) {
    this.store = store;
  }

  public List<LineItemImportDraft> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<LineItemImportDraft> lineItems) {
    this.lineItems = lineItems;
  }

  public List<CustomLineItemImportDraft> getCustomLineItems() {
    return customLineItems;
  }

  public void setCustomLineItems(List<CustomLineItemImportDraft> customLineItems) {
    this.customLineItems = customLineItems;
  }

  public MoneyInput getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(MoneyInput totalPrice) {
    this.totalPrice = totalPrice;
  }

  public TaxedPriceDraft getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedPriceDraft taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public AddressInput getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(AddressInput billingAddress) {
    this.billingAddress = billingAddress;
  }

  public ReferenceInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ReferenceInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public ShippingInfoImportDraft getShippingInfo() {
    return shippingInfo;
  }

  public void setShippingInfo(ShippingInfoImportDraft shippingInfo) {
    this.shippingInfo = shippingInfo;
  }

  public OffsetDateTime getCompletedAt() {
    return completedAt;
  }

  public void setCompletedAt(OffsetDateTime completedAt) {
    this.completedAt = completedAt;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public ItemShippingDetailsDraft getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraft shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public CartOrigin getOrigin() {
    return origin;
  }

  public void setOrigin(CartOrigin origin) {
    this.origin = origin;
  }

  public List<AddressInput> getItemShippingAddresses() {
    return itemShippingAddresses;
  }

  public void setItemShippingAddresses(List<AddressInput> itemShippingAddresses) {
    this.itemShippingAddresses = itemShippingAddresses;
  }

  public ReferenceInput getState() {
    return state;
  }

  public void setState(ReferenceInput state) {
    this.state = state;
  }

  public ReferenceInput getPaymentInfo() {
    return paymentInfo;
  }

  public void setPaymentInfo(ReferenceInput paymentInfo) {
    this.paymentInfo = paymentInfo;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  @Override
  public String toString() {
    return "ImportOrderDraft{orderNumber='" + orderNumber + "', customerId='" + customerId + "', customerEmail='" + customerEmail + "', store='" + store + "', lineItems='" + lineItems + "', customLineItems='" + customLineItems + "', totalPrice='" + totalPrice + "', taxedPrice='" + taxedPrice + "', shippingAddress='" + shippingAddress + "', billingAddress='" + billingAddress + "', customerGroup='" + customerGroup + "', country='" + country + "', orderState='" + orderState + "', shipmentState='" + shipmentState + "', paymentState='" + paymentState + "', shippingInfo='" + shippingInfo + "', completedAt='" + completedAt + "', custom='" + custom + "', inventoryMode='" + inventoryMode + "', shippingDetails='" + shippingDetails + "', taxCalculationMode='" + taxCalculationMode + "', origin='" + origin + "', itemShippingAddresses='" + itemShippingAddresses + "', state='" + state + "', paymentInfo='" + paymentInfo + "', purchaseOrderNumber='" + purchaseOrderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImportOrderDraft that = (ImportOrderDraft) o;
    return Objects.equals(orderNumber, that.orderNumber) &&
        Objects.equals(customerId, that.customerId) &&
        Objects.equals(customerEmail, that.customerEmail) &&
        Objects.equals(store, that.store) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(customLineItems, that.customLineItems) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(billingAddress, that.billingAddress) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(country, that.country) &&
        Objects.equals(orderState, that.orderState) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(shippingInfo, that.shippingInfo) &&
        Objects.equals(completedAt, that.completedAt) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(taxCalculationMode, that.taxCalculationMode) &&
        Objects.equals(origin, that.origin) &&
        Objects.equals(itemShippingAddresses, that.itemShippingAddresses) &&
        Objects.equals(state, that.state) &&
        Objects.equals(paymentInfo, that.paymentInfo) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderNumber, customerId, customerEmail, store, lineItems, customLineItems, totalPrice, taxedPrice, shippingAddress, billingAddress, customerGroup, country, orderState, shipmentState, paymentState, shippingInfo, completedAt, custom, inventoryMode, shippingDetails, taxCalculationMode, origin, itemShippingAddresses, state, paymentInfo, purchaseOrderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String orderNumber;

    private String customerId;

    private String customerEmail;

    private ReferenceInput store;

    private List<LineItemImportDraft> lineItems = Collections.emptyList();

    private List<CustomLineItemImportDraft> customLineItems = Collections.emptyList();

    private MoneyInput totalPrice;

    private TaxedPriceDraft taxedPrice;

    private AddressInput shippingAddress;

    private AddressInput billingAddress;

    private ReferenceInput customerGroup;

    private String country;

    private OrderState orderState;

    private ShipmentState shipmentState;

    private PaymentState paymentState;

    private ShippingInfoImportDraft shippingInfo;

    private OffsetDateTime completedAt;

    private CustomFieldsDraft custom;

    private InventoryMode inventoryMode = InventoryMode.None;

    private ItemShippingDetailsDraft shippingDetails;

    private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;

    private CartOrigin origin = CartOrigin.Customer;

    private List<AddressInput> itemShippingAddresses = Collections.emptyList();

    private ReferenceInput state;

    private ReferenceInput paymentInfo;

    private String purchaseOrderNumber;

    public ImportOrderDraft build() {
      ImportOrderDraft result = new ImportOrderDraft();
      result.orderNumber = this.orderNumber;
      result.customerId = this.customerId;
      result.customerEmail = this.customerEmail;
      result.store = this.store;
      result.lineItems = this.lineItems;
      result.customLineItems = this.customLineItems;
      result.totalPrice = this.totalPrice;
      result.taxedPrice = this.taxedPrice;
      result.shippingAddress = this.shippingAddress;
      result.billingAddress = this.billingAddress;
      result.customerGroup = this.customerGroup;
      result.country = this.country;
      result.orderState = this.orderState;
      result.shipmentState = this.shipmentState;
      result.paymentState = this.paymentState;
      result.shippingInfo = this.shippingInfo;
      result.completedAt = this.completedAt;
      result.custom = this.custom;
      result.inventoryMode = this.inventoryMode;
      result.shippingDetails = this.shippingDetails;
      result.taxCalculationMode = this.taxCalculationMode;
      result.origin = this.origin;
      result.itemShippingAddresses = this.itemShippingAddresses;
      result.state = this.state;
      result.paymentInfo = this.paymentInfo;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      return result;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }

    public Builder customerEmail(String customerEmail) {
      this.customerEmail = customerEmail;
      return this;
    }

    public Builder store(ReferenceInput store) {
      this.store = store;
      return this;
    }

    public Builder lineItems(List<LineItemImportDraft> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder customLineItems(List<CustomLineItemImportDraft> customLineItems) {
      this.customLineItems = customLineItems;
      return this;
    }

    public Builder totalPrice(MoneyInput totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder taxedPrice(TaxedPriceDraft taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder billingAddress(AddressInput billingAddress) {
      this.billingAddress = billingAddress;
      return this;
    }

    public Builder customerGroup(ReferenceInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder shippingInfo(ShippingInfoImportDraft shippingInfo) {
      this.shippingInfo = shippingInfo;
      return this;
    }

    public Builder completedAt(OffsetDateTime completedAt) {
      this.completedAt = completedAt;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraft shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }

    public Builder origin(CartOrigin origin) {
      this.origin = origin;
      return this;
    }

    public Builder itemShippingAddresses(List<AddressInput> itemShippingAddresses) {
      this.itemShippingAddresses = itemShippingAddresses;
      return this;
    }

    public Builder state(ReferenceInput state) {
      this.state = state;
      return this;
    }

    public Builder paymentInfo(ReferenceInput paymentInfo) {
      this.paymentInfo = paymentInfo;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }
  }
}
