package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ImportOrderLineItemState {
  private String lineItemId;

  private String lineItemKey;

  private List<ItemStateDraftType> state;

  public ImportOrderLineItemState() {
  }

  public ImportOrderLineItemState(String lineItemId, String lineItemKey,
      List<ItemStateDraftType> state) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.state = state;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public List<ItemStateDraftType> getState() {
    return state;
  }

  public void setState(List<ItemStateDraftType> state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ImportOrderLineItemState{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImportOrderLineItemState that = (ImportOrderLineItemState) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private List<ItemStateDraftType> state;

    public ImportOrderLineItemState build() {
      ImportOrderLineItemState result = new ImportOrderLineItemState();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.state = this.state;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder state(List<ItemStateDraftType> state) {
      this.state = state;
      return this;
    }
  }
}
