package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ImportStagedOrderLineItemStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private String lineItemKey;

  private Object state;

  public ImportStagedOrderLineItemStateOutput() {
  }

  public ImportStagedOrderLineItemStateOutput(String type, String lineItemId, String lineItemKey,
      Object state) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.state = state;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Object getState() {
    return state;
  }

  public void setState(Object state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ImportStagedOrderLineItemStateOutput{type='" + type + "', lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImportStagedOrderLineItemStateOutput that = (ImportStagedOrderLineItemStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, lineItemKey, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private String lineItemKey;

    private Object state;

    public ImportStagedOrderLineItemStateOutput build() {
      ImportStagedOrderLineItemStateOutput result = new ImportStagedOrderLineItemStateOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.state = this.state;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder state(Object state) {
      this.state = state;
      return this;
    }
  }
}
