package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InStore implements com.commercetools.graphql.api.types.CartDiscountQueryInterface, com.commercetools.graphql.api.types.CartQueryInterface, com.commercetools.graphql.api.types.CustomerActiveCartInterface, com.commercetools.graphql.api.types.OrderQueryInterface, com.commercetools.graphql.api.types.CustomerQueryInterface, com.commercetools.graphql.api.types.ShippingMethodsByCartInterface, com.commercetools.graphql.api.types.MeFieldInterface {
  /**
   * This field can only be used with an access token created with the password flow or with an anonymous session.
   *
   * It gives access to the data that is specific to the customer or the anonymous session linked to the access token.
   */
  private InStoreMe me;

  private List<ShippingMethod> shippingMethodsByCart;

  private CartDiscount cartDiscount;

  private CartDiscountQueryResult cartDiscounts;

  private Product product;

  private Customer customer;

  private CustomerQueryResult customers;

  private Cart cart;

  private CartQueryResult carts;

  private Cart customerActiveCart;

  private Order order;

  private OrderQueryResult orders;

  private ShoppingList shoppingList;

  private ShoppingListQueryResult shoppingLists;

  private ProductAssignmentQueryResult productSelectionAssignments;

  private ProductTailoring productTailoring;

  private ProductTailoringQueryResult productTailoringList;

  private QuoteRequest quoteRequest;

  private QuoteRequestQueryResult quoteRequests;

  private StagedQuote stagedQuote;

  private StagedQuoteQueryResult stagedQuotes;

  private Quote quote;

  private QuoteQueryResult quotes;

  private BusinessUnit businessUnit;

  private BusinessUnitQueryResult businessUnits;

  public InStore() {
  }

  public InStore(InStoreMe me, List<ShippingMethod> shippingMethodsByCart,
      CartDiscount cartDiscount, CartDiscountQueryResult cartDiscounts, Product product,
      Customer customer, CustomerQueryResult customers, Cart cart, CartQueryResult carts,
      Cart customerActiveCart, Order order, OrderQueryResult orders, ShoppingList shoppingList,
      ShoppingListQueryResult shoppingLists,
      ProductAssignmentQueryResult productSelectionAssignments, ProductTailoring productTailoring,
      ProductTailoringQueryResult productTailoringList, QuoteRequest quoteRequest,
      QuoteRequestQueryResult quoteRequests, StagedQuote stagedQuote,
      StagedQuoteQueryResult stagedQuotes, Quote quote, QuoteQueryResult quotes,
      BusinessUnit businessUnit, BusinessUnitQueryResult businessUnits) {
    this.me = me;
    this.shippingMethodsByCart = shippingMethodsByCart;
    this.cartDiscount = cartDiscount;
    this.cartDiscounts = cartDiscounts;
    this.product = product;
    this.customer = customer;
    this.customers = customers;
    this.cart = cart;
    this.carts = carts;
    this.customerActiveCart = customerActiveCart;
    this.order = order;
    this.orders = orders;
    this.shoppingList = shoppingList;
    this.shoppingLists = shoppingLists;
    this.productSelectionAssignments = productSelectionAssignments;
    this.productTailoring = productTailoring;
    this.productTailoringList = productTailoringList;
    this.quoteRequest = quoteRequest;
    this.quoteRequests = quoteRequests;
    this.stagedQuote = stagedQuote;
    this.stagedQuotes = stagedQuotes;
    this.quote = quote;
    this.quotes = quotes;
    this.businessUnit = businessUnit;
    this.businessUnits = businessUnits;
  }

  /**
   * This field can only be used with an access token created with the password flow or with an anonymous session.
   *
   * It gives access to the data that is specific to the customer or the anonymous session linked to the access token.
   */
  public InStoreMe getMe() {
    return me;
  }

  public void setMe(InStoreMe me) {
    this.me = me;
  }

  public List<ShippingMethod> getShippingMethodsByCart() {
    return shippingMethodsByCart;
  }

  public void setShippingMethodsByCart(List<ShippingMethod> shippingMethodsByCart) {
    this.shippingMethodsByCart = shippingMethodsByCart;
  }

  public CartDiscount getCartDiscount() {
    return cartDiscount;
  }

  public void setCartDiscount(CartDiscount cartDiscount) {
    this.cartDiscount = cartDiscount;
  }

  public CartDiscountQueryResult getCartDiscounts() {
    return cartDiscounts;
  }

  public void setCartDiscounts(CartDiscountQueryResult cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public CustomerQueryResult getCustomers() {
    return customers;
  }

  public void setCustomers(CustomerQueryResult customers) {
    this.customers = customers;
  }

  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  public CartQueryResult getCarts() {
    return carts;
  }

  public void setCarts(CartQueryResult carts) {
    this.carts = carts;
  }

  public Cart getCustomerActiveCart() {
    return customerActiveCart;
  }

  public void setCustomerActiveCart(Cart customerActiveCart) {
    this.customerActiveCart = customerActiveCart;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public OrderQueryResult getOrders() {
    return orders;
  }

  public void setOrders(OrderQueryResult orders) {
    this.orders = orders;
  }

  public ShoppingList getShoppingList() {
    return shoppingList;
  }

  public void setShoppingList(ShoppingList shoppingList) {
    this.shoppingList = shoppingList;
  }

  public ShoppingListQueryResult getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListQueryResult shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  public ProductAssignmentQueryResult getProductSelectionAssignments() {
    return productSelectionAssignments;
  }

  public void setProductSelectionAssignments(
      ProductAssignmentQueryResult productSelectionAssignments) {
    this.productSelectionAssignments = productSelectionAssignments;
  }

  public ProductTailoring getProductTailoring() {
    return productTailoring;
  }

  public void setProductTailoring(ProductTailoring productTailoring) {
    this.productTailoring = productTailoring;
  }

  public ProductTailoringQueryResult getProductTailoringList() {
    return productTailoringList;
  }

  public void setProductTailoringList(ProductTailoringQueryResult productTailoringList) {
    this.productTailoringList = productTailoringList;
  }

  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public QuoteRequestQueryResult getQuoteRequests() {
    return quoteRequests;
  }

  public void setQuoteRequests(QuoteRequestQueryResult quoteRequests) {
    this.quoteRequests = quoteRequests;
  }

  public StagedQuote getStagedQuote() {
    return stagedQuote;
  }

  public void setStagedQuote(StagedQuote stagedQuote) {
    this.stagedQuote = stagedQuote;
  }

  public StagedQuoteQueryResult getStagedQuotes() {
    return stagedQuotes;
  }

  public void setStagedQuotes(StagedQuoteQueryResult stagedQuotes) {
    this.stagedQuotes = stagedQuotes;
  }

  public Quote getQuote() {
    return quote;
  }

  public void setQuote(Quote quote) {
    this.quote = quote;
  }

  public QuoteQueryResult getQuotes() {
    return quotes;
  }

  public void setQuotes(QuoteQueryResult quotes) {
    this.quotes = quotes;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public BusinessUnitQueryResult getBusinessUnits() {
    return businessUnits;
  }

  public void setBusinessUnits(BusinessUnitQueryResult businessUnits) {
    this.businessUnits = businessUnits;
  }

  @Override
  public String toString() {
    return "InStore{me='" + me + "', shippingMethodsByCart='" + shippingMethodsByCart + "', cartDiscount='" + cartDiscount + "', cartDiscounts='" + cartDiscounts + "', product='" + product + "', customer='" + customer + "', customers='" + customers + "', cart='" + cart + "', carts='" + carts + "', customerActiveCart='" + customerActiveCart + "', order='" + order + "', orders='" + orders + "', shoppingList='" + shoppingList + "', shoppingLists='" + shoppingLists + "', productSelectionAssignments='" + productSelectionAssignments + "', productTailoring='" + productTailoring + "', productTailoringList='" + productTailoringList + "', quoteRequest='" + quoteRequest + "', quoteRequests='" + quoteRequests + "', stagedQuote='" + stagedQuote + "', stagedQuotes='" + stagedQuotes + "', quote='" + quote + "', quotes='" + quotes + "', businessUnit='" + businessUnit + "', businessUnits='" + businessUnits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InStore that = (InStore) o;
    return Objects.equals(me, that.me) &&
        Objects.equals(shippingMethodsByCart, that.shippingMethodsByCart) &&
        Objects.equals(cartDiscount, that.cartDiscount) &&
        Objects.equals(cartDiscounts, that.cartDiscounts) &&
        Objects.equals(product, that.product) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(customers, that.customers) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(customerActiveCart, that.customerActiveCart) &&
        Objects.equals(order, that.order) &&
        Objects.equals(orders, that.orders) &&
        Objects.equals(shoppingList, that.shoppingList) &&
        Objects.equals(shoppingLists, that.shoppingLists) &&
        Objects.equals(productSelectionAssignments, that.productSelectionAssignments) &&
        Objects.equals(productTailoring, that.productTailoring) &&
        Objects.equals(productTailoringList, that.productTailoringList) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(quoteRequests, that.quoteRequests) &&
        Objects.equals(stagedQuote, that.stagedQuote) &&
        Objects.equals(stagedQuotes, that.stagedQuotes) &&
        Objects.equals(quote, that.quote) &&
        Objects.equals(quotes, that.quotes) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnits, that.businessUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(me, shippingMethodsByCart, cartDiscount, cartDiscounts, product, customer, customers, cart, carts, customerActiveCart, order, orders, shoppingList, shoppingLists, productSelectionAssignments, productTailoring, productTailoringList, quoteRequest, quoteRequests, stagedQuote, stagedQuotes, quote, quotes, businessUnit, businessUnits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    /**
     * This field can only be used with an access token created with the password flow or with an anonymous session.
     *
     * It gives access to the data that is specific to the customer or the anonymous session linked to the access token.
     */
    private InStoreMe me;

    private List<ShippingMethod> shippingMethodsByCart;

    private CartDiscount cartDiscount;

    private CartDiscountQueryResult cartDiscounts;

    private Product product;

    private Customer customer;

    private CustomerQueryResult customers;

    private Cart cart;

    private CartQueryResult carts;

    private Cart customerActiveCart;

    private Order order;

    private OrderQueryResult orders;

    private ShoppingList shoppingList;

    private ShoppingListQueryResult shoppingLists;

    private ProductAssignmentQueryResult productSelectionAssignments;

    private ProductTailoring productTailoring;

    private ProductTailoringQueryResult productTailoringList;

    private QuoteRequest quoteRequest;

    private QuoteRequestQueryResult quoteRequests;

    private StagedQuote stagedQuote;

    private StagedQuoteQueryResult stagedQuotes;

    private Quote quote;

    private QuoteQueryResult quotes;

    private BusinessUnit businessUnit;

    private BusinessUnitQueryResult businessUnits;

    public InStore build() {
      InStore result = new InStore();
      result.me = this.me;
      result.shippingMethodsByCart = this.shippingMethodsByCart;
      result.cartDiscount = this.cartDiscount;
      result.cartDiscounts = this.cartDiscounts;
      result.product = this.product;
      result.customer = this.customer;
      result.customers = this.customers;
      result.cart = this.cart;
      result.carts = this.carts;
      result.customerActiveCart = this.customerActiveCart;
      result.order = this.order;
      result.orders = this.orders;
      result.shoppingList = this.shoppingList;
      result.shoppingLists = this.shoppingLists;
      result.productSelectionAssignments = this.productSelectionAssignments;
      result.productTailoring = this.productTailoring;
      result.productTailoringList = this.productTailoringList;
      result.quoteRequest = this.quoteRequest;
      result.quoteRequests = this.quoteRequests;
      result.stagedQuote = this.stagedQuote;
      result.stagedQuotes = this.stagedQuotes;
      result.quote = this.quote;
      result.quotes = this.quotes;
      result.businessUnit = this.businessUnit;
      result.businessUnits = this.businessUnits;
      return result;
    }

    /**
     * This field can only be used with an access token created with the password flow or with an anonymous session.
     *
     * It gives access to the data that is specific to the customer or the anonymous session linked to the access token.
     */
    public Builder me(InStoreMe me) {
      this.me = me;
      return this;
    }

    public Builder shippingMethodsByCart(List<ShippingMethod> shippingMethodsByCart) {
      this.shippingMethodsByCart = shippingMethodsByCart;
      return this;
    }

    public Builder cartDiscount(CartDiscount cartDiscount) {
      this.cartDiscount = cartDiscount;
      return this;
    }

    public Builder cartDiscounts(CartDiscountQueryResult cartDiscounts) {
      this.cartDiscounts = cartDiscounts;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder customers(CustomerQueryResult customers) {
      this.customers = customers;
      return this;
    }

    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }

    public Builder carts(CartQueryResult carts) {
      this.carts = carts;
      return this;
    }

    public Builder customerActiveCart(Cart customerActiveCart) {
      this.customerActiveCart = customerActiveCart;
      return this;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder orders(OrderQueryResult orders) {
      this.orders = orders;
      return this;
    }

    public Builder shoppingList(ShoppingList shoppingList) {
      this.shoppingList = shoppingList;
      return this;
    }

    public Builder shoppingLists(ShoppingListQueryResult shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }

    public Builder productSelectionAssignments(
        ProductAssignmentQueryResult productSelectionAssignments) {
      this.productSelectionAssignments = productSelectionAssignments;
      return this;
    }

    public Builder productTailoring(ProductTailoring productTailoring) {
      this.productTailoring = productTailoring;
      return this;
    }

    public Builder productTailoringList(ProductTailoringQueryResult productTailoringList) {
      this.productTailoringList = productTailoringList;
      return this;
    }

    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder quoteRequests(QuoteRequestQueryResult quoteRequests) {
      this.quoteRequests = quoteRequests;
      return this;
    }

    public Builder stagedQuote(StagedQuote stagedQuote) {
      this.stagedQuote = stagedQuote;
      return this;
    }

    public Builder stagedQuotes(StagedQuoteQueryResult stagedQuotes) {
      this.stagedQuotes = stagedQuotes;
      return this;
    }

    public Builder quote(Quote quote) {
      this.quote = quote;
      return this;
    }

    public Builder quotes(QuoteQueryResult quotes) {
      this.quotes = quotes;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnits(BusinessUnitQueryResult businessUnits) {
      this.businessUnits = businessUnits;
      return this;
    }
  }
}
