package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InStoreMe implements com.commercetools.graphql.api.types.MeQueryInterface, com.commercetools.graphql.api.types.CartQueryInterface, com.commercetools.graphql.api.types.ActiveCartInterface, com.commercetools.graphql.api.types.OrderQueryInterface, com.commercetools.graphql.api.types.ShoppingListQueryInterface {
  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Customer customer;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Cart cart;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private CartQueryResult carts;

  private Cart activeCart;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private Order order;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private OrderQueryResult orders;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ShoppingList shoppingList;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ShoppingListQueryResult shoppingLists;

  public InStoreMe() {
  }

  public InStoreMe(Customer customer, Cart cart, CartQueryResult carts, Cart activeCart,
      Order order, OrderQueryResult orders, ShoppingList shoppingList,
      ShoppingListQueryResult shoppingLists) {
    this.customer = customer;
    this.cart = cart;
    this.carts = carts;
    this.activeCart = activeCart;
    this.order = order;
    this.orders = orders;
    this.shoppingList = shoppingList;
    this.shoppingLists = shoppingLists;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public CartQueryResult getCarts() {
    return carts;
  }

  public void setCarts(CartQueryResult carts) {
    this.carts = carts;
  }

  public Cart getActiveCart() {
    return activeCart;
  }

  public void setActiveCart(Cart activeCart) {
    this.activeCart = activeCart;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public OrderQueryResult getOrders() {
    return orders;
  }

  public void setOrders(OrderQueryResult orders) {
    this.orders = orders;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ShoppingList getShoppingList() {
    return shoppingList;
  }

  public void setShoppingList(ShoppingList shoppingList) {
    this.shoppingList = shoppingList;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ShoppingListQueryResult getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListQueryResult shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  @Override
  public String toString() {
    return "InStoreMe{customer='" + customer + "', cart='" + cart + "', carts='" + carts + "', activeCart='" + activeCart + "', order='" + order + "', orders='" + orders + "', shoppingList='" + shoppingList + "', shoppingLists='" + shoppingLists + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InStoreMe that = (InStoreMe) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(activeCart, that.activeCart) &&
        Objects.equals(order, that.order) &&
        Objects.equals(orders, that.orders) &&
        Objects.equals(shoppingList, that.shoppingList) &&
        Objects.equals(shoppingLists, that.shoppingLists);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, cart, carts, activeCart, order, orders, shoppingList, shoppingLists);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Customer customer;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Cart cart;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private CartQueryResult carts;

    private Cart activeCart;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private Order order;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private OrderQueryResult orders;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ShoppingList shoppingList;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ShoppingListQueryResult shoppingLists;

    public InStoreMe build() {
      InStoreMe result = new InStoreMe();
      result.customer = this.customer;
      result.cart = this.cart;
      result.carts = this.carts;
      result.activeCart = this.activeCart;
      result.order = this.order;
      result.orders = this.orders;
      result.shoppingList = this.shoppingList;
      result.shoppingLists = this.shoppingLists;
      return result;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder carts(CartQueryResult carts) {
      this.carts = carts;
      return this;
    }

    public Builder activeCart(Cart activeCart) {
      this.activeCart = activeCart;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder orders(OrderQueryResult orders) {
      this.orders = orders;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder shoppingList(ShoppingList shoppingList) {
      this.shoppingList = shoppingList;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder shoppingLists(ShoppingListQueryResult shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }
  }
}
