package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class InheritedAssociate {
  private List<InheritedAssociateRoleAssignment> associateRoleAssignments;

  private Reference customerRef;

  private Customer customer;

  public InheritedAssociate() {
  }

  public InheritedAssociate(List<InheritedAssociateRoleAssignment> associateRoleAssignments,
      Reference customerRef, Customer customer) {
    this.associateRoleAssignments = associateRoleAssignments;
    this.customerRef = customerRef;
    this.customer = customer;
  }

  public List<InheritedAssociateRoleAssignment> getAssociateRoleAssignments() {
    return associateRoleAssignments;
  }

  public void setAssociateRoleAssignments(
      List<InheritedAssociateRoleAssignment> associateRoleAssignments) {
    this.associateRoleAssignments = associateRoleAssignments;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  @Override
  public String toString() {
    return "InheritedAssociate{associateRoleAssignments='" + associateRoleAssignments + "', customerRef='" + customerRef + "', customer='" + customer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InheritedAssociate that = (InheritedAssociate) o;
    return Objects.equals(associateRoleAssignments, that.associateRoleAssignments) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRoleAssignments, customerRef, customer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<InheritedAssociateRoleAssignment> associateRoleAssignments;

    private Reference customerRef;

    private Customer customer;

    public InheritedAssociate build() {
      InheritedAssociate result = new InheritedAssociate();
      result.associateRoleAssignments = this.associateRoleAssignments;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      return result;
    }

    public Builder associateRoleAssignments(
        List<InheritedAssociateRoleAssignment> associateRoleAssignments) {
      this.associateRoleAssignments = associateRoleAssignments;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }
  }
}
