package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class InheritedAssociateRoleAssignment {
  private KeyReference associateRoleRef;

  private AssociateRole associateRole;

  private KeyReference sourceRef;

  private BusinessUnit source;

  public InheritedAssociateRoleAssignment() {
  }

  public InheritedAssociateRoleAssignment(KeyReference associateRoleRef,
      AssociateRole associateRole, KeyReference sourceRef, BusinessUnit source) {
    this.associateRoleRef = associateRoleRef;
    this.associateRole = associateRole;
    this.sourceRef = sourceRef;
    this.source = source;
  }

  public KeyReference getAssociateRoleRef() {
    return associateRoleRef;
  }

  public void setAssociateRoleRef(KeyReference associateRoleRef) {
    this.associateRoleRef = associateRoleRef;
  }

  public AssociateRole getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(AssociateRole associateRole) {
    this.associateRole = associateRole;
  }

  public KeyReference getSourceRef() {
    return sourceRef;
  }

  public void setSourceRef(KeyReference sourceRef) {
    this.sourceRef = sourceRef;
  }

  public BusinessUnit getSource() {
    return source;
  }

  public void setSource(BusinessUnit source) {
    this.source = source;
  }

  @Override
  public String toString() {
    return "InheritedAssociateRoleAssignment{associateRoleRef='" + associateRoleRef + "', associateRole='" + associateRole + "', sourceRef='" + sourceRef + "', source='" + source + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InheritedAssociateRoleAssignment that = (InheritedAssociateRoleAssignment) o;
    return Objects.equals(associateRoleRef, that.associateRoleRef) &&
        Objects.equals(associateRole, that.associateRole) &&
        Objects.equals(sourceRef, that.sourceRef) &&
        Objects.equals(source, that.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRoleRef, associateRole, sourceRef, source);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference associateRoleRef;

    private AssociateRole associateRole;

    private KeyReference sourceRef;

    private BusinessUnit source;

    public InheritedAssociateRoleAssignment build() {
      InheritedAssociateRoleAssignment result = new InheritedAssociateRoleAssignment();
      result.associateRoleRef = this.associateRoleRef;
      result.associateRole = this.associateRole;
      result.sourceRef = this.sourceRef;
      result.source = this.source;
      return result;
    }

    public Builder associateRoleRef(KeyReference associateRoleRef) {
      this.associateRoleRef = associateRoleRef;
      return this;
    }

    public Builder associateRole(AssociateRole associateRole) {
      this.associateRole = associateRole;
      return this;
    }

    public Builder sourceRef(KeyReference sourceRef) {
      this.sourceRef = sourceRef;
      return this;
    }

    public Builder source(BusinessUnit source) {
      this.source = source;
      return this;
    }
  }
}
