package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Initiator {
  private Boolean isPlatformClient;

  private String externalUserId;

  private String anonymousId;

  private Attribution attributedTo;

  private String clientId;

  private Reference customerRef;

  private Reference userRef;

  private Reference associateRef;

  public Initiator() {
  }

  public Initiator(Boolean isPlatformClient, String externalUserId, String anonymousId,
      Attribution attributedTo, String clientId, Reference customerRef, Reference userRef,
      Reference associateRef) {
    this.isPlatformClient = isPlatformClient;
    this.externalUserId = externalUserId;
    this.anonymousId = anonymousId;
    this.attributedTo = attributedTo;
    this.clientId = clientId;
    this.customerRef = customerRef;
    this.userRef = userRef;
    this.associateRef = associateRef;
  }

  public Boolean getIsPlatformClient() {
    return isPlatformClient;
  }

  public void setIsPlatformClient(Boolean isPlatformClient) {
    this.isPlatformClient = isPlatformClient;
  }

  public String getExternalUserId() {
    return externalUserId;
  }

  public void setExternalUserId(String externalUserId) {
    this.externalUserId = externalUserId;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public Attribution getAttributedTo() {
    return attributedTo;
  }

  public void setAttributedTo(Attribution attributedTo) {
    this.attributedTo = attributedTo;
  }

  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Reference getUserRef() {
    return userRef;
  }

  public void setUserRef(Reference userRef) {
    this.userRef = userRef;
  }

  public Reference getAssociateRef() {
    return associateRef;
  }

  public void setAssociateRef(Reference associateRef) {
    this.associateRef = associateRef;
  }

  @Override
  public String toString() {
    return "Initiator{isPlatformClient='" + isPlatformClient + "', externalUserId='" + externalUserId + "', anonymousId='" + anonymousId + "', attributedTo='" + attributedTo + "', clientId='" + clientId + "', customerRef='" + customerRef + "', userRef='" + userRef + "', associateRef='" + associateRef + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Initiator that = (Initiator) o;
    return Objects.equals(isPlatformClient, that.isPlatformClient) &&
        Objects.equals(externalUserId, that.externalUserId) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(attributedTo, that.attributedTo) &&
        Objects.equals(clientId, that.clientId) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(userRef, that.userRef) &&
        Objects.equals(associateRef, that.associateRef);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isPlatformClient, externalUserId, anonymousId, attributedTo, clientId, customerRef, userRef, associateRef);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean isPlatformClient;

    private String externalUserId;

    private String anonymousId;

    private Attribution attributedTo;

    private String clientId;

    private Reference customerRef;

    private Reference userRef;

    private Reference associateRef;

    public Initiator build() {
      Initiator result = new Initiator();
      result.isPlatformClient = this.isPlatformClient;
      result.externalUserId = this.externalUserId;
      result.anonymousId = this.anonymousId;
      result.attributedTo = this.attributedTo;
      result.clientId = this.clientId;
      result.customerRef = this.customerRef;
      result.userRef = this.userRef;
      result.associateRef = this.associateRef;
      return result;
    }

    public Builder isPlatformClient(Boolean isPlatformClient) {
      this.isPlatformClient = isPlatformClient;
      return this;
    }

    public Builder externalUserId(String externalUserId) {
      this.externalUserId = externalUserId;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder attributedTo(Attribution attributedTo) {
      this.attributedTo = attributedTo;
      return this;
    }

    public Builder clientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder userRef(Reference userRef) {
      this.userRef = userRef;
      return this;
    }

    public Builder associateRef(Reference associateRef) {
      this.associateRef = associateRef;
      return this;
    }
  }
}
