package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class InterfaceInteractionsRaw {
  private Reference typeRef;

  private TypeDefinition type;

  private List<RawCustomField> fields;

  public InterfaceInteractionsRaw() {
  }

  public InterfaceInteractionsRaw(Reference typeRef, TypeDefinition type,
      List<RawCustomField> fields) {
    this.typeRef = typeRef;
    this.type = type;
    this.fields = fields;
  }

  public Reference getTypeRef() {
    return typeRef;
  }

  public void setTypeRef(Reference typeRef) {
    this.typeRef = typeRef;
  }

  public TypeDefinition getType() {
    return type;
  }

  public void setType(TypeDefinition type) {
    this.type = type;
  }

  public List<RawCustomField> getFields() {
    return fields;
  }

  public void setFields(List<RawCustomField> fields) {
    this.fields = fields;
  }

  @Override
  public String toString() {
    return "InterfaceInteractionsRaw{typeRef='" + typeRef + "', type='" + type + "', fields='" + fields + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InterfaceInteractionsRaw that = (InterfaceInteractionsRaw) o;
    return Objects.equals(typeRef, that.typeRef) &&
        Objects.equals(type, that.type) &&
        Objects.equals(fields, that.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeRef, type, fields);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference typeRef;

    private TypeDefinition type;

    private List<RawCustomField> fields;

    public InterfaceInteractionsRaw build() {
      InterfaceInteractionsRaw result = new InterfaceInteractionsRaw();
      result.typeRef = this.typeRef;
      result.type = this.type;
      result.fields = this.fields;
      return result;
    }

    public Builder typeRef(Reference typeRef) {
      this.typeRef = typeRef;
      return this;
    }

    public Builder type(TypeDefinition type) {
      this.type = type;
      return this;
    }

    public Builder fields(List<RawCustomField> fields) {
      this.fields = fields;
      return this;
    }
  }
}
