package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * Inventory allows you to track stock quantity per SKU and optionally per supply channel
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class InventoryEntry implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String sku;

  private Long quantityOnStock;

  private Long availableQuantity;

  private String key;

  private Integer restockableInDays;

  private OffsetDateTime expectedDelivery;

  private Channel supplyChannel;

  private Reference supplyChannelRef;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public InventoryEntry() {
  }

  public InventoryEntry(String sku, Long quantityOnStock, Long availableQuantity, String key,
      Integer restockableInDays, OffsetDateTime expectedDelivery, Channel supplyChannel,
      Reference supplyChannelRef, CustomFieldsType custom, String id, Long version,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.sku = sku;
    this.quantityOnStock = quantityOnStock;
    this.availableQuantity = availableQuantity;
    this.key = key;
    this.restockableInDays = restockableInDays;
    this.expectedDelivery = expectedDelivery;
    this.supplyChannel = supplyChannel;
    this.supplyChannelRef = supplyChannelRef;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Long getQuantityOnStock() {
    return quantityOnStock;
  }

  public void setQuantityOnStock(Long quantityOnStock) {
    this.quantityOnStock = quantityOnStock;
  }

  public Long getAvailableQuantity() {
    return availableQuantity;
  }

  public void setAvailableQuantity(Long availableQuantity) {
    this.availableQuantity = availableQuantity;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Integer getRestockableInDays() {
    return restockableInDays;
  }

  public void setRestockableInDays(Integer restockableInDays) {
    this.restockableInDays = restockableInDays;
  }

  public OffsetDateTime getExpectedDelivery() {
    return expectedDelivery;
  }

  public void setExpectedDelivery(OffsetDateTime expectedDelivery) {
    this.expectedDelivery = expectedDelivery;
  }

  public Channel getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(Channel supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Reference getSupplyChannelRef() {
    return supplyChannelRef;
  }

  public void setSupplyChannelRef(Reference supplyChannelRef) {
    this.supplyChannelRef = supplyChannelRef;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "InventoryEntry{sku='" + sku + "', quantityOnStock='" + quantityOnStock + "', availableQuantity='" + availableQuantity + "', key='" + key + "', restockableInDays='" + restockableInDays + "', expectedDelivery='" + expectedDelivery + "', supplyChannel='" + supplyChannel + "', supplyChannelRef='" + supplyChannelRef + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InventoryEntry that = (InventoryEntry) o;
    return Objects.equals(sku, that.sku) &&
        Objects.equals(quantityOnStock, that.quantityOnStock) &&
        Objects.equals(availableQuantity, that.availableQuantity) &&
        Objects.equals(key, that.key) &&
        Objects.equals(restockableInDays, that.restockableInDays) &&
        Objects.equals(expectedDelivery, that.expectedDelivery) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(supplyChannelRef, that.supplyChannelRef) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sku, quantityOnStock, availableQuantity, key, restockableInDays, expectedDelivery, supplyChannel, supplyChannelRef, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sku;

    private Long quantityOnStock;

    private Long availableQuantity;

    private String key;

    private Integer restockableInDays;

    private OffsetDateTime expectedDelivery;

    private Channel supplyChannel;

    private Reference supplyChannelRef;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public InventoryEntry build() {
      InventoryEntry result = new InventoryEntry();
      result.sku = this.sku;
      result.quantityOnStock = this.quantityOnStock;
      result.availableQuantity = this.availableQuantity;
      result.key = this.key;
      result.restockableInDays = this.restockableInDays;
      result.expectedDelivery = this.expectedDelivery;
      result.supplyChannel = this.supplyChannel;
      result.supplyChannelRef = this.supplyChannelRef;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder quantityOnStock(Long quantityOnStock) {
      this.quantityOnStock = quantityOnStock;
      return this;
    }

    public Builder availableQuantity(Long availableQuantity) {
      this.availableQuantity = availableQuantity;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder restockableInDays(Integer restockableInDays) {
      this.restockableInDays = restockableInDays;
      return this;
    }

    public Builder expectedDelivery(OffsetDateTime expectedDelivery) {
      this.expectedDelivery = expectedDelivery;
      return this;
    }

    public Builder supplyChannel(Channel supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder supplyChannelRef(Reference supplyChannelRef) {
      this.supplyChannelRef = supplyChannelRef;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
